/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.successfactors.api;

import com.successfactors.sfapi.server.SFAPI;
import com.successfactors.sfapi.server.SFWebServiceFaultException;
import com.successfactors.sfapi.sfobject.DeleteResult;
import com.successfactors.sfapi.sfobject.DescribeResult;
import com.successfactors.sfapi.sfobject.DescribeSFObjects;
import com.successfactors.sfapi.sfobject.DescribeSFObjectsResponse;
import com.successfactors.sfapi.sfobject.Error;
import com.successfactors.sfapi.sfobject.GetJobResult;
import com.successfactors.sfapi.sfobject.InsertResult;
import com.successfactors.sfapi.sfobject.ListSFObjects;
import com.successfactors.sfapi.sfobject.ListSFObjectsResponse;
import com.successfactors.sfapi.sfobject.LoginResult;
import com.successfactors.sfapi.sfobject.QueryResult;
import com.successfactors.sfapi.sfobject.SFCredential;
import com.successfactors.sfapi.sfobject.SFObject;
import com.successfactors.sfapi.sfobject.SFParameter;
import com.successfactors.sfapi.sfobject.TaskStatus;
import com.successfactors.sfapi.sfobject.UpdateResult;
import com.successfactors.sfapi.sfobject.UpsertResult;
import java.util.List;
import javax.activation.DataHandler;
import javax.xml.ws.BindingProvider;
import org.mule.module.successfactors.api.SuccessFactorsClientBase;
import org.mule.module.successfactors.execptions.SuccessFactorsConnectorException;

public class SuccessFactorsClientImpl
extends SuccessFactorsClientBase {
    protected String sessionId = null;
    private SFAPI client = null;

    public SuccessFactorsClientImpl(String wsdlLocation, String companyId, String username, String password) {
        super(wsdlLocation, companyId, username, password);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public void initClient() throws SuccessFactorsConnectorException {
        if (this.client == null) {
            this.client = super.getClientInstance();
            ((BindingProvider)this.client).getRequestContext().put("javax.xml.ws.session.maintain", true);
        }
    }

    @Override
    public void login(List<SFParameter> params) throws SuccessFactorsConnectorException {
        SFCredential credentials = new SFCredential();
        credentials.setCompanyId(this.companyId);
        credentials.setUsername(this.username);
        credentials.setPassword(this.password);
        LoginResult lr = null;
        try {
            lr = this.client.login(credentials, params);
        }
        catch (SFWebServiceFaultException e) {
            throw new SuccessFactorsConnectorException(e.getFaultInfo(), (Throwable)e);
        }
        if (lr.getErrors() != null && lr.getErrors().size() > 0) {
            Error err = lr.getErrors().get(0);
            if (err != null) {
                throw new SuccessFactorsConnectorException(err.getErrorCode(), err.getErrorMessage());
            }
            throw new SuccessFactorsConnectorException("ERROR. Unknown authentication problem");
        }
    }

    @Override
    public boolean logout() throws SuccessFactorsConnectorException {
        try {
            return this.client.logout();
        }
        catch (SFWebServiceFaultException e) {
            throw new SuccessFactorsConnectorException(e.getFaultInfo(), (Throwable)e);
        }
    }

    @Override
    public boolean isValidSession() throws SuccessFactorsConnectorException {
        if (this.sessionId == null) {
            return false;
        }
        try {
            return this.client.isValidSession();
        }
        catch (SFWebServiceFaultException e) {
            throw new SuccessFactorsConnectorException(e.getFaultInfo(), (Throwable)e);
        }
    }

    @Override
    public void release() {
        super.release();
        this.sessionId = null;
        this.client = null;
    }

    @Override
    public List<String> listEntities() throws SuccessFactorsConnectorException {
        ListSFObjectsResponse list = null;
        try {
            list = this.client.list(new ListSFObjects());
        }
        catch (SFWebServiceFaultException e) {
            throw new SuccessFactorsConnectorException(e.getFaultInfo(), (Throwable)e);
        }
        return list.getNames();
    }

    @Override
    public List<DescribeResult> describeEntities(DescribeSFObjects params) throws SuccessFactorsConnectorException {
        DescribeSFObjectsResponse dr = null;
        try {
            dr = this.client.describe(params);
        }
        catch (SFWebServiceFaultException e) {
            throw new SuccessFactorsConnectorException(e.getFaultInfo(), (Throwable)e);
        }
        return dr.getResults();
    }

    @Override
    public InsertResult insert(String type, List<SFObject> objects, List<SFParameter> processingParams) throws SuccessFactorsConnectorException {
        try {
            return this.client.insert(type, objects, processingParams);
        }
        catch (SFWebServiceFaultException e) {
            throw new SuccessFactorsConnectorException(e.getFaultInfo(), (Throwable)e);
        }
    }

    @Override
    public UpdateResult update(String type, List<SFObject> objects, List<SFParameter> processingParams) throws SuccessFactorsConnectorException {
        try {
            return this.client.update(type, objects, processingParams);
        }
        catch (SFWebServiceFaultException e) {
            throw new SuccessFactorsConnectorException(e.getFaultInfo(), (Throwable)e);
        }
    }

    @Override
    public UpsertResult upsert(String type, List<SFObject> objects, List<SFParameter> processingParams) throws SuccessFactorsConnectorException {
        try {
            return this.client.upsert(type, objects, processingParams);
        }
        catch (SFWebServiceFaultException e) {
            throw new SuccessFactorsConnectorException(e.getFaultInfo(), (Throwable)e);
        }
    }

    @Override
    public DeleteResult delete(String type, List<SFObject> objects, List<SFParameter> processingParams) throws SuccessFactorsConnectorException {
        try {
            return this.client.delete(type, objects, processingParams);
        }
        catch (SFWebServiceFaultException e) {
            throw new SuccessFactorsConnectorException(e.getFaultInfo(), (Throwable)e);
        }
    }

    @Override
    public QueryResult query(String queryString, List<SFParameter> params) throws SuccessFactorsConnectorException {
        try {
            return this.client.query(queryString, params);
        }
        catch (SFWebServiceFaultException e) {
            throw new SuccessFactorsConnectorException(e.getFaultInfo(), (Throwable)e);
        }
    }

    @Override
    public QueryResult queryMore(String querySessionId) throws SuccessFactorsConnectorException {
        try {
            return this.client.queryMore(querySessionId);
        }
        catch (SFWebServiceFaultException e) {
            throw new SuccessFactorsConnectorException(e.getFaultInfo(), (Throwable)e);
        }
    }

    @Override
    public TaskStatus submitQueryJob(String queryString, List<SFParameter> params) throws SuccessFactorsConnectorException {
        try {
            return this.client.submitQueryJob(queryString, params);
        }
        catch (SFWebServiceFaultException e) {
            throw new SuccessFactorsConnectorException(e.getFaultInfo(), (Throwable)e);
        }
    }

    @Override
    public TaskStatus getJobStatus(String taskId) throws SuccessFactorsConnectorException {
        try {
            return this.client.getJobStatus(taskId);
        }
        catch (SFWebServiceFaultException e) {
            throw new SuccessFactorsConnectorException(e.getFaultInfo(), (Throwable)e);
        }
    }

    @Override
    public DataHandler getJobResult(GetJobResult params) throws SuccessFactorsConnectorException {
        try {
            return this.client.getJobResult(params);
        }
        catch (SFWebServiceFaultException e) {
            throw new SuccessFactorsConnectorException(e.getFaultInfo(), (Throwable)e);
        }
    }

    @Override
    public List<TaskStatus> listJobs() throws SuccessFactorsConnectorException {
        try {
            return this.client.listJobs();
        }
        catch (SFWebServiceFaultException e) {
            throw new SuccessFactorsConnectorException(e.getFaultInfo(), (Throwable)e);
        }
    }

    @Override
    public TaskStatus cancelJob(String taskId) throws SuccessFactorsConnectorException {
        try {
            return this.client.cancelJob(taskId);
        }
        catch (SFWebServiceFaultException e) {
            throw new SuccessFactorsConnectorException(e.getFaultInfo(), (Throwable)e);
        }
    }
}

