/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.successfactors.config;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.config.spring.parsers.generic.AutoIdUtils;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public abstract class AbstractDefinitionParser
implements BeanDefinitionParser {
    private TemplateParser.PatternInfo patternInfo = TemplateParser.createMuleStyleParser().getStyle();

    protected boolean hasAttribute(Element element, String attributeName) {
        String value = element.getAttribute(attributeName);
        return value != null && !StringUtils.isBlank((String)value);
    }

    protected void setRef(BeanDefinitionBuilder builder, String propertyName, String ref) {
        if (!this.isMuleExpression(ref)) {
            builder.addPropertyValue(propertyName, (Object)new RuntimeBeanReference(ref));
        } else {
            builder.addPropertyValue(propertyName, (Object)ref);
        }
    }

    protected boolean isMuleExpression(String value) {
        return value.startsWith(this.patternInfo.getPrefix()) || value.endsWith(this.patternInfo.getSuffix());
    }

    protected ManagedList parseList(Element element, String childElementName, ParseDelegate parserDelegate) {
        ManagedList managedList = new ManagedList();
        List childDomElements = DomUtils.getChildElementsByTagName((Element)element, (String)childElementName);
        for (Element childDomElement : childDomElements) {
            if (this.hasAttribute(childDomElement, "value-ref")) {
                if (!this.isMuleExpression(childDomElement.getAttribute("value-ref"))) {
                    managedList.add((Object)new RuntimeBeanReference(childDomElement.getAttribute("value-ref")));
                    continue;
                }
                managedList.add((Object)childDomElement.getAttribute("value-ref"));
                continue;
            }
            managedList.add(parserDelegate.parse(childDomElement));
        }
        return managedList;
    }

    protected void parseListAndSetProperty(Element element, BeanDefinitionBuilder builder, String fieldName, String parentElementName, String childElementName, ParseDelegate parserDelegate) {
        Element domElement = DomUtils.getChildElementByTagName((Element)element, (String)parentElementName);
        if (domElement != null) {
            if (this.hasAttribute(domElement, "ref")) {
                this.setRef(builder, fieldName, domElement.getAttribute("ref"));
            } else {
                ManagedList managedList = this.parseList(domElement, childElementName, parserDelegate);
                builder.addPropertyValue(fieldName, (Object)managedList);
            }
        }
    }

    protected ManagedMap parseMap(Element element, String childElementName, ParseDelegate parserDelegate) {
        ManagedMap managedMap = new ManagedMap();
        List childDomElements = DomUtils.getChildElementsByTagName((Element)element, (String)childElementName);
        if (childDomElements.size() == 0) {
            childDomElements = DomUtils.getChildElements((Element)element);
        }
        for (Element childDomElement : childDomElements) {
            Object key = null;
            key = this.hasAttribute(childDomElement, "key-ref") ? new RuntimeBeanReference(childDomElement.getAttribute("key-ref")) : (this.hasAttribute(childDomElement, "key") ? childDomElement.getAttribute("key") : childDomElement.getTagName());
            if (this.hasAttribute(childDomElement, "value-ref")) {
                if (!this.isMuleExpression(childDomElement.getAttribute("value-ref"))) {
                    managedMap.put(key, (Object)new RuntimeBeanReference(childDomElement.getAttribute("value-ref")));
                    continue;
                }
                managedMap.put(key, (Object)childDomElement.getAttribute("value-ref"));
                continue;
            }
            managedMap.put(key, parserDelegate.parse(childDomElement));
        }
        return managedMap;
    }

    protected void parseMapAndSetProperty(Element element, BeanDefinitionBuilder builder, String fieldName, String parentElementName, String childElementName, ParseDelegate parserDelegate) {
        Element domElement = DomUtils.getChildElementByTagName((Element)element, (String)parentElementName);
        if (domElement != null) {
            if (this.hasAttribute(domElement, "ref")) {
                this.setRef(builder, fieldName, domElement.getAttribute("ref"));
            } else {
                ManagedMap managedMap = this.parseMap(domElement, childElementName, parserDelegate);
                builder.addPropertyValue(fieldName, (Object)managedMap);
            }
        }
    }

    protected void parseMapWithDefaultAndSetProperty(Element element, BeanDefinitionBuilder builder, String fieldName, String parentElementName, String childElementName, String defaultValue, ParseDelegate parserDelegate) {
        Element domElement = DomUtils.getChildElementByTagName((Element)element, (String)parentElementName);
        if (domElement != null) {
            if (this.hasAttribute(domElement, "ref")) {
                this.setRef(builder, fieldName, domElement.getAttribute("ref"));
            } else {
                ManagedMap managedMap = this.parseMap(domElement, childElementName, parserDelegate);
                builder.addPropertyValue(fieldName, (Object)managedMap);
            }
        } else {
            builder.addPropertyValue(fieldName, (Object)defaultValue);
        }
    }

    protected void parseListWithDefaultAndSetProperty(Element element, BeanDefinitionBuilder builder, String fieldName, String parentElementName, String childElementName, String defaultValue, ParseDelegate parserDelegate) {
        Element domElement = DomUtils.getChildElementByTagName((Element)element, (String)parentElementName);
        if (domElement != null) {
            if (this.hasAttribute(domElement, "ref")) {
                this.setRef(builder, fieldName, domElement.getAttribute("ref"));
            } else {
                ManagedList managedList = this.parseList(domElement, childElementName, parserDelegate);
                builder.addPropertyValue(fieldName, (Object)managedList);
            }
        } else {
            builder.addPropertyValue(fieldName, (Object)defaultValue);
        }
    }

    protected void parseConfigRef(Element element, BeanDefinitionBuilder builder) {
        if (this.hasAttribute(element, "config-ref")) {
            String configRef = element.getAttribute("config-ref");
            if (configRef.startsWith("#[")) {
                builder.addPropertyValue("moduleObject", (Object)configRef);
            } else {
                builder.addPropertyValue("moduleObject", (Object)new RuntimeBeanReference(configRef));
            }
        }
    }

    protected void attachProcessorDefinition(ParserContext parserContext, BeanDefinition definition) {
        MutablePropertyValues propertyValues = parserContext.getContainingBeanDefinition().getPropertyValues();
        if (parserContext.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", (Object)definition);
        } else if (parserContext.getContainingBeanDefinition().getBeanClassName().equals("org.mule.enricher.MessageEnricher")) {
            propertyValues.addPropertyValue("enrichmentMessageProcessor", (Object)definition);
        } else {
            PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
            if (messageProcessors == null || messageProcessors.getValue() == null) {
                propertyValues.addPropertyValue("messageProcessors", (Object)new ManagedList());
            }
            List listMessageProcessors = (List)propertyValues.getPropertyValue("messageProcessors").getValue();
            listMessageProcessors.add(definition);
        }
    }

    protected void attachSourceDefinition(ParserContext parserContext, BeanDefinition definition) {
        MutablePropertyValues propertyValues = parserContext.getContainingBeanDefinition().getPropertyValues();
        propertyValues.addPropertyValue("messageSource", (Object)definition);
    }

    protected String getAttributeValue(Element element, String attributeName) {
        if (!StringUtils.isEmpty((String)element.getAttribute(attributeName))) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    protected void parseConfigName(Element element) {
        if (this.hasAttribute(element, "name")) {
            element.setAttribute("name", AutoIdUtils.getUniqueName((Element)element, (String)"mule-bean"));
        }
    }

    protected void setInitMethodIfNeeded(BeanDefinitionBuilder builder, Class clazz) {
        if (Initialisable.class.isAssignableFrom(clazz)) {
            builder.setInitMethodName("initialise");
        }
    }

    protected void setDestroyMethodIfNeeded(BeanDefinitionBuilder builder, Class clazz) {
        if (Disposable.class.isAssignableFrom(clazz)) {
            builder.setDestroyMethodName("dispose");
        }
    }

    protected void parseProperty(BeanDefinitionBuilder builder, Element element, String propertyName) {
        this.parseProperty(builder, element, propertyName, propertyName);
    }

    protected void parseProperty(BeanDefinitionBuilder builder, Element element, String attributeName, String propertyName) {
        if (this.hasAttribute(element, attributeName)) {
            builder.addPropertyValue(propertyName, (Object)element.getAttribute(attributeName));
        }
    }

    protected void setNoRecurseOnDefinition(BeanDefinition definition) {
        definition.setAttribute("org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE", (Object)Boolean.TRUE);
    }

    protected String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId((Element)element);
        if (StringUtils.isBlank((String)id)) {
            String parentId = SpringXMLUtils.getNameOrId((Element)((Element)element.getParentNode()));
            return "." + parentId + ":" + element.getLocalName();
        }
        return id;
    }

    protected BeanDefinition parseNestedProcessor(Element element, ParserContext parserContext, Class factory) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((Class)factory);
        AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
        parserContext.getRegistry().registerBeanDefinition(this.generateChildBeanName(element), (BeanDefinition)beanDefinition);
        element.setAttribute("name", this.generateChildBeanName(element));
        builder.setSource(parserContext.extractSource((Object)element));
        builder.setScope("singleton");
        List list = parserContext.getDelegate().parseListElement(element, (BeanDefinition)builder.getBeanDefinition());
        parserContext.getRegistry().removeBeanDefinition(this.generateChildBeanName(element));
        return beanDefinition;
    }

    protected List parseNestedProcessorAsList(Element element, ParserContext parserContext, Class factory) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((Class)factory);
        AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
        parserContext.getRegistry().registerBeanDefinition(this.generateChildBeanName(element), (BeanDefinition)beanDefinition);
        element.setAttribute("name", this.generateChildBeanName(element));
        builder.setSource(parserContext.extractSource((Object)element));
        builder.setScope("singleton");
        List list = parserContext.getDelegate().parseListElement(element, (BeanDefinition)builder.getBeanDefinition());
        parserContext.getRegistry().removeBeanDefinition(this.generateChildBeanName(element));
        return list;
    }

    protected void parseNestedProcessorAsListAndSetProperty(Element element, ParserContext parserContext, Class factory, BeanDefinitionBuilder builder, String propertyName) {
        builder.addPropertyValue(propertyName, (Object)this.parseNestedProcessorAsList(element, parserContext, factory));
    }

    protected void parseNestedProcessorAndSetProperty(Element element, ParserContext parserContext, Class factory, BeanDefinitionBuilder builder, String propertyName) {
        builder.addPropertyValue(propertyName, (Object)this.parseNestedProcessor(element, parserContext, factory));
    }

    protected void parseNestedProcessorAsListAndSetProperty(Element element, String childElementName, ParserContext parserContext, Class factory, BeanDefinitionBuilder builder, String propertyName) {
        Element childDomElement = DomUtils.getChildElementByTagName((Element)element, (String)childElementName);
        if (childDomElement != null) {
            builder.addPropertyValue(propertyName, (Object)this.parseNestedProcessorAsList(childDomElement, parserContext, factory));
        }
    }

    protected void parseNestedProcessorAndSetProperty(Element element, String childElementName, ParserContext parserContext, Class factory, BeanDefinitionBuilder builder, String propertyName) {
        Element childDomElement = DomUtils.getChildElementByTagName((Element)element, (String)childElementName);
        if (childDomElement != null) {
            builder.addPropertyValue(propertyName, (Object)this.parseNestedProcessor(childDomElement, parserContext, factory));
        }
    }

    protected void parseRetryPolicyTemplate(String elementName, Element element, ParserContext parserContext, BeanDefinitionBuilder builder, BeanDefinition definition) {
        Element reconnectElement = DomUtils.getChildElementByTagName((Element)element, (String)elementName);
        if (reconnectElement != null) {
            parserContext.getRegistry().registerBeanDefinition(this.getAttributeValue(element, "name"), definition);
            BeanDefinition retryPolicyBeanDefinition = parserContext.getDelegate().parseCustomElement(reconnectElement);
            parserContext.getRegistry().removeBeanDefinition(this.getAttributeValue(element, "name"));
            builder.addPropertyValue("retryPolicyTemplate", (Object)retryPolicyBeanDefinition);
        }
    }

    protected boolean parseObjectRef(Element element, BeanDefinitionBuilder builder, String elementName, String propertyName) {
        Element childElement = DomUtils.getChildElementByTagName((Element)element, (String)elementName);
        if (childElement != null && this.hasAttribute(childElement, "ref")) {
            if (childElement.getAttribute("ref").startsWith("#")) {
                builder.addPropertyValue(propertyName, (Object)childElement.getAttribute("ref"));
            } else {
                builder.addPropertyValue(propertyName, (Object)("#[registry:" + childElement.getAttribute("ref") + "]"));
            }
            return true;
        }
        return false;
    }

    protected boolean parseObjectRefWithDefault(Element element, BeanDefinitionBuilder builder, String elementName, String propertyName, String defaultValue) {
        Element childElement = DomUtils.getChildElementByTagName((Element)element, (String)elementName);
        if (childElement != null) {
            if (this.hasAttribute(childElement, "ref")) {
                if (childElement.getAttribute("ref").startsWith("#")) {
                    builder.addPropertyValue(propertyName, (Object)childElement.getAttribute("ref"));
                } else {
                    builder.addPropertyValue(propertyName, (Object)("#[registry:" + childElement.getAttribute("ref") + "]"));
                }
                return true;
            }
        } else {
            builder.addPropertyValue(propertyName, (Object)defaultValue);
        }
        return false;
    }

    protected void parsePropertyRef(BeanDefinitionBuilder builder, Element element, String attributeName, String propertyName) {
        if (this.hasAttribute(element, attributeName)) {
            builder.addPropertyValue(propertyName, (Object)new RuntimeBeanReference(element.getAttribute(attributeName)));
        }
    }

    protected void parsePropertyRef(BeanDefinitionBuilder builder, Element element, String propertyName) {
        this.parsePropertyRef(builder, element, propertyName, propertyName);
    }

    protected void parseTextProperty(BeanDefinitionBuilder builder, Element element, String elementName, String propertyName) {
        Element childElement = DomUtils.getChildElementByTagName((Element)element, (String)elementName);
        if (childElement != null) {
            builder.addPropertyValue(propertyName, (Object)childElement.getTextContent());
        }
    }

    public static interface ParseDelegate<T> {
        public T parse(Element var1);
    }
}

