/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.successfactors.connectivity;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.module.successfactors.adapters.SuccessFactorsConnectorConnectionIdentifierAdapter;
import org.mule.module.successfactors.connectivity.SuccessFactorsConnectorConnectionKey;
import org.mule.module.successfactors.connectivity.SuccessFactorsConnectorConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuccessFactorsConnectorConnectionFactory
implements KeyedPoolableObjectFactory {
    private static Logger logger = LoggerFactory.getLogger(SuccessFactorsConnectorConnectionFactory.class);
    private SuccessFactorsConnectorConnectionManager connectionManager;

    public SuccessFactorsConnectorConnectionFactory(SuccessFactorsConnectorConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Object makeObject(Object key) throws Exception {
        if (!(key instanceof SuccessFactorsConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        SuccessFactorsConnectorConnectionIdentifierAdapter connector = new SuccessFactorsConnectorConnectionIdentifierAdapter();
        connector.setWsdlLocation(this.connectionManager.getWsdlLocation());
        connector.setCompanyId(this.connectionManager.getCompanyId());
        if (connector instanceof Initialisable) {
            connector.initialise();
        }
        if (connector instanceof MuleContextAware) {
            ((MuleContextAware)connector).setMuleContext(this.connectionManager.getMuleContext());
        }
        if (connector instanceof Startable) {
            connector.start();
        }
        return connector;
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        if (!(key instanceof SuccessFactorsConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof SuccessFactorsConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        try {
            ((SuccessFactorsConnectorConnectionIdentifierAdapter)obj).disconnect();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if ((SuccessFactorsConnectorConnectionIdentifierAdapter)obj instanceof Stoppable) {
                ((Stoppable)obj).stop();
            }
            if ((SuccessFactorsConnectorConnectionIdentifierAdapter)obj instanceof Disposable) {
                ((Disposable)obj).dispose();
            }
        }
    }

    public boolean validateObject(Object key, Object obj) {
        if (!(obj instanceof SuccessFactorsConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        try {
            return ((SuccessFactorsConnectorConnectionIdentifierAdapter)obj).isConnected();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void activateObject(Object key, Object obj) throws Exception {
        if (!(key instanceof SuccessFactorsConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof SuccessFactorsConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        if (!((SuccessFactorsConnectorConnectionIdentifierAdapter)obj).isConnected()) {
            ((SuccessFactorsConnectorConnectionIdentifierAdapter)obj).connect(((SuccessFactorsConnectorConnectionKey)key).getUsername(), ((SuccessFactorsConnectorConnectionKey)key).getPassword());
        }
    }

    public void passivateObject(Object key, Object obj) throws Exception {
    }
}

