
package org.mule.module.xmlsecurity.config.spring;

import org.apache.commons.lang.StringUtils;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.parsers.generic.AutoIdUtils;
import org.mule.module.xmlsecurity.config.XmlSecurityModuleLifecycleAdapter;
import org.mule.util.TemplateParser;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class XmlSecurityModuleConfigDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public XmlSecurityModuleConfigDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        String name = element.getAttribute("name");
        if ((name == null)||StringUtils.isBlank(name)) {
            element.setAttribute("name", AutoIdUtils.getUniqueName(element, "mule-bean"));
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(XmlSecurityModuleLifecycleAdapter.class.getName());
        if (Initialisable.class.isAssignableFrom(XmlSecurityModuleLifecycleAdapter.class)) {
            builder.setInitMethodName(Initialisable.PHASE_NAME);
        }
        if (Disposable.class.isAssignableFrom(XmlSecurityModuleLifecycleAdapter.class)) {
            builder.setDestroyMethodName(Disposable.PHASE_NAME);
        }
        if (element.hasAttribute("signatureType")) {
            builder.addPropertyValue("signatureType", element.getAttribute("signatureType"));
        }
        if ((element.getAttribute("password")!= null)&&(!StringUtils.isBlank(element.getAttribute("password")))) {
            builder.addPropertyValue("password", element.getAttribute("password"));
        }
        if ((element.getAttribute("keystore")!= null)&&(!StringUtils.isBlank(element.getAttribute("keystore")))) {
            builder.addPropertyValue("keystore", element.getAttribute("keystore"));
        }
        if ((element.getAttribute("keystoreKey")!= null)&&(!StringUtils.isBlank(element.getAttribute("keystoreKey")))) {
            builder.addPropertyValue("keystoreKey", element.getAttribute("keystoreKey"));
        }
        if ((element.getAttribute("secretKeyAlgorithm")!= null)&&(!StringUtils.isBlank(element.getAttribute("secretKeyAlgorithm")))) {
            builder.addPropertyValue("secretKeyAlgorithm", element.getAttribute("secretKeyAlgorithm"));
        }
        if ((element.getAttribute("referenceURI")!= null)&&(!StringUtils.isBlank(element.getAttribute("referenceURI")))) {
            builder.addPropertyValue("referenceURI", element.getAttribute("referenceURI"));
        }
        if ((element.getAttribute("keyPairAlgorithm")!= null)&&(!StringUtils.isBlank(element.getAttribute("keyPairAlgorithm")))) {
            builder.addPropertyValue("keyPairAlgorithm", element.getAttribute("keyPairAlgorithm"));
        }
        if (element.hasAttribute("digestMethodAlgorithm")) {
            builder.addPropertyValue("digestMethodAlgorithm", element.getAttribute("digestMethodAlgorithm"));
        }
        if (element.hasAttribute("canonicalizationAlgorithm")) {
            builder.addPropertyValue("canonicalizationAlgorithm", element.getAttribute("canonicalizationAlgorithm"));
        }
        if (element.hasAttribute("signatureMethodAlgorithm")) {
            builder.addPropertyValue("signatureMethodAlgorithm", element.getAttribute("signatureMethodAlgorithm"));
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        return definition;
    }

}
