package org.mule.module.xmlsecurity.keyinfo;

import org.mule.module.xmlsecurity.algorithms.CanonicalizationAlgorithm;
import org.mule.module.xmlsecurity.algorithms.SignatureMethodAlgorithm;

import javax.crypto.spec.SecretKeySpec;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import java.security.Key;
import java.util.Collections;

import static org.mule.module.xmlsecurity.Signer.fac;

/**
 * <p>Generates the Key Info using a secret key provided by the User</p>
 *
 * @author  fernando.federico@mulesource.com
 */
public class ScretKeyInfoProvider implements KeyInfoProvider{
    private String secretKey;
    private String secretKeyAlgorithm;
    private CanonicalizationAlgorithm canonicalizationAlgorithm;

    /**
     * Constructor
     *
     * @param secretKey The password provided by the user
     * @param secretKeyAlgorithm The algorithm used to encode the key
     * @param canonicalizationAlgorithm The canonicalization Algorithm
     */
    public ScretKeyInfoProvider(String secretKey,
                                String secretKeyAlgorithm,
                                CanonicalizationAlgorithm canonicalizationAlgorithm) {
        this.secretKey = secretKey;
        this.secretKeyAlgorithm = secretKeyAlgorithm;
        this.canonicalizationAlgorithm = canonicalizationAlgorithm;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public KeyInfo getKeyInfo() {
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Key getSecretKey() {
        return new SecretKeySpec(secretKey.getBytes(), secretKeyAlgorithm);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SignedInfo getSignedInfo(Reference ref) {

        try{
            return fac.newSignedInfo
                    (fac.newCanonicalizationMethod
                            (canonicalizationAlgorithm.getAlgorithm(),
                                    (C14NMethodParameterSpec) null),
                            fac.newSignatureMethod(SignatureMethodAlgorithm.HMAC_SHA1.getAlgorithm(), null),
                            Collections.singletonList(ref));
        }
        catch(Exception e)
        {
            throw new RuntimeException("Signed Info could not be created", e);
        }


    }

}
