package org.mule.module.xmlsecurity.reference;

import javax.xml.crypto.dsig.Reference;
import java.util.List;

/**
 * <p>Generates a reference object to be signed</p>
 *
 * @author fernando.federico@mulesource.com
 *
 */
public interface ReferenceProvider {

    /**
     * <p>Generates the reference that is signed.</p>
     *
     * @return The Reference Object
     */
    Reference getReference();

    /**
     * <p>If Inner objects are needed as reference (for example, for an enveloping signature),
     * it returns the referenced tags</p>
     *
     * @return The List of Objects
     */
    List<Object> getReferencedObjects();
}
