package org.mule.module.xmlsecurity.validator;

import org.mule.module.xmlsecurity.Signer;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

import javax.crypto.spec.SecretKeySpec;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.dom.DOMValidateContext;

/**
 * <p>Validator of xmls signed with a Secret key</p>
 *
 * @author fernando.federico@mulesource.com
 */
public class SecretKeyValidator implements SignatureValidator {

    private String key;
    private String keyAlgorithm;

    /**
     * Constructore
     * @param keyAlgorithm The secret key algorithm (used to encode it)
     * @param key the secret password
     */
    public SecretKeyValidator(String keyAlgorithm, String key) {
        this.keyAlgorithm = keyAlgorithm;
        this.key = key;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean validate(Document doc) throws MarshalException, XMLSignatureException {
        NodeList nl =
                doc.getElementsByTagNameNS(XMLSignature.XMLNS, "Signature");

        if (nl.getLength() == 0) {
            throw new RuntimeException("Cannot find Signature element");
        }

        DOMValidateContext valContext = new DOMValidateContext(
                new SecretKeySpec(key.getBytes(), keyAlgorithm), nl.item(0));

        XMLSignature signature = Signer.fac.unmarshalXMLSignature(valContext);
        return signature.validate(valContext);
    }
}
