package org.mule.module.xmlsecurity;

import org.mule.module.xmlsecurity.keyinfo.KeyInfoProvider;
import org.mule.module.xmlsecurity.reference.ReferenceProvider;
import org.w3c.dom.Document;

import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;

/**
 * <p>Xml signer</p>
 *
 * @author fernando.federico@mulesource.com
 */
public class Signer{

    public static XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");

    private KeyInfoProvider keyInfoProvider;
    private ReferenceProvider referenceProvider;

    /**
     * Constructor
     *
     * @param keyInfoProvider The key info provider
     * @param referenceProvider The reference provider
     */
    public Signer(KeyInfoProvider keyInfoProvider, ReferenceProvider referenceProvider) {
        this.keyInfoProvider = keyInfoProvider;
        this.referenceProvider = referenceProvider;
    }

    /**
     * <p>Signs the document</p>
     *
     * @param doc Document to be signed
     */
    public void sign(Document doc) {
        try{

            XMLSignature signature = fac.newXMLSignature(keyInfoProvider.getSignedInfo(referenceProvider.getReference()),
                                                         keyInfoProvider.getKeyInfo(),
                                                         referenceProvider.getReferencedObjects(), null, null);
            DOMSignContext signContext = new DOMSignContext(keyInfoProvider.getSecretKey(), doc.getDocumentElement());

            signature.sign(signContext);
        }
        catch(Exception e)
        {
            throw new RuntimeException("Could not add Signature to the document", e);
        }
    }
}
