package org.mule.module.xmlsecurity.algorithms;

import javax.xml.crypto.dsig.CanonicalizationMethod;

/**
 * <p>Enumeration of the accepted Canonicalization Algorithms</p>
 * <p>For a definition of Canonicalization methods
 * see  <a href="http://www.w3.org/TR/2009/WD-xmlsec-algorithms-20090226/#canonicalization-uris">Canonicalization Algorithms</a></p>
 *
 * @author fernando.federico@mulesource.com
 */
public enum CanonicalizationAlgorithm {
    /**
     * <a href="http://www.w3.org/TR/xml-exc-c14n/#sec-Use">Exclusive canonicalization</a>
     */
    EXCLUSIVE (CanonicalizationMethod.EXCLUSIVE),
    /**
     * <a href="http://www.w3.org/TR/xml-exc-c14n/#sec-Use">Exclusive with comments canonicalization</a>
     */
    EXCLUSIVE_WITH_COMMENTS (CanonicalizationMethod.EXCLUSIVE_WITH_COMMENTS),
    /**
     * <a href="http://www.w3.org/TR/2008/REC-xmldsig-core-20080610/#sec-Canonical">Inclusive Canonicalization</a>
     */
    INCLUSIVE (CanonicalizationMethod.INCLUSIVE),
    /**
     * <a href="http://www.w3.org/TR/2008/REC-xmldsig-core-20080610/#sec-Canonical">Inclusive with comments canonicalization</a>
     */
    INCLUSE_WITH_COMMENTS (CanonicalizationMethod.INCLUSIVE_WITH_COMMENTS);

    private final String algorithm;

    CanonicalizationAlgorithm(String algorithm)
    {
        this.algorithm = algorithm;
    }

    /**
     * Used to get the string uri for the canonicalization algorithm
     *
     * @return The Canonicalization algorithm
     */
    public String getAlgorithm() {
        return algorithm;
    }
}
