package org.mule.module.xmlsecurity.algorithms;

import javax.xml.crypto.dsig.SignatureMethod;

/**
 * <p>Enumeration of the Signature Method Algorithms </p>
 * <p>For a definition of Signature Methods
 * see  <a href="http://www.w3.org/TR/2009/WD-xmlsec-algorithms-20090226/#signature-method-uris">
 *     Signature Method algorithm</a></p>
 *
 * @author fernando.federico@mulesource.com
 */
public enum SignatureMethodAlgorithm {
    /**
     * <a href="http://www.w3.org/TR/2008/REC-xmldsig-core-20080610/#sec-PKCS1">RSA SHA1</a>
     */
    RSA_SHA1(SignatureMethod.RSA_SHA1),
    /**
     * <a href="http://www.w3.org/TR/2008/REC-xmldsig-core-20080610/#sec-DSA">DSA SHA1</a>
     */
    DSA_SHA1(SignatureMethod.DSA_SHA1),
    /**
     * <a href="http://www.w3.org/TR/2008/REC-xmldsig-core-20080610/#sec-MACs">HMAC SHA1</a>
     */
    HMAC_SHA1(SignatureMethod.HMAC_SHA1);

    private final String algorithm;

    SignatureMethodAlgorithm(String algorithm)
    {
        this.algorithm = algorithm;
    }

    /**
     * Used to get the string uri for the Signature Method algorithm
     *
     * @return The Signature Method algorithm
     */
    public String getAlgorithm() {
        return algorithm;
    }
}
