package org.mule.module.xmlsecurity.reference;

import org.mule.module.xmlsecurity.algorithms.DigestMethodAlgorithm;

import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import java.util.Collections;
import java.util.List;

import static org.mule.module.xmlsecurity.Signer.fac;

/**
 * <p>Generates a reference to the Xml envelope</p>
 *
 * @author fernando.federico@mulesource.com
 */
public class EnvelopedReferenceProvider implements ReferenceProvider {


    private DigestMethodAlgorithm digestMethodAlgorithm;

    /**
     * Constructor
     *
     * @param digestMethodAlgorithm The digest Method algorithm
     */
    public EnvelopedReferenceProvider(DigestMethodAlgorithm digestMethodAlgorithm) {
        this.digestMethodAlgorithm = digestMethodAlgorithm;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Reference getReference() {
        try {

            return fac.newReference
                    ("", fac.newDigestMethod(digestMethodAlgorithm.getAlgorithm(), null),
                            Collections.singletonList
                                    (fac.newTransform
                                            (Transform.ENVELOPED, (TransformParameterSpec) null)),
                            null, null);
        } catch (Exception e){
            throw new RuntimeException("Could not getReference Enveloping Reference", e);
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public List<Object> getReferencedObjects() {
        return null;
    }
}
