/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mql.mule;

import com.mulesoft.mql.mule.MqlTransformer;
import com.mulesoft.mql.mule.Type;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChainBuilder;
import org.mule.api.routing.filter.Filter;
import org.mule.api.source.MessageSource;
import org.mule.construct.AbstractFlowConstruct;
import org.mule.module.json.transformers.JsonToObject;
import org.mule.module.json.transformers.ObjectToJson;
import org.mule.processor.NullMessageProcessor;
import org.mule.processor.ResponseMessageProcessorAdapter;
import org.mule.routing.ChoiceRouter;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.http.transformers.FormTransformer;

public class QueryService
extends AbstractFlowConstruct {
    private final String query;
    private final Type type;

    public QueryService(String name, String query, Type type, MessageSource messageSource, MuleContext muleContext) {
        super(name, muleContext);
        this.type = type;
        this.query = query;
        this.setMessageSource(messageSource);
    }

    protected void configureMessageProcessors(MessageProcessorChainBuilder builder) throws MuleException {
        if (this.type == Type.JSON) {
            this.createJsonTransformers(builder);
        }
        Filter formFilter = this.getFormFilter();
        FormTransformer formTransformer = new FormTransformer();
        ChoiceRouter choiceRouter = new ChoiceRouter();
        choiceRouter.addRoute((MessageProcessor)formTransformer, formFilter);
        MqlTransformer mqlTransformer = new MqlTransformer();
        mqlTransformer.setQuery(this.query);
        builder.chain(new MessageProcessor[]{mqlTransformer});
    }

    protected void createJsonTransformers(MessageProcessorChainBuilder builder) throws InitialisationException {
        JsonToObject jsonToObject = new JsonToObject();
        jsonToObject.setReturnDataType(DataTypeFactory.create(Object.class));
        ChoiceRouter choiceRouter = new ChoiceRouter();
        choiceRouter.addRoute((MessageProcessor)jsonToObject, this.getJsonFilter());
        choiceRouter.setDefaultRoute((MessageProcessor)new NullMessageProcessor());
        builder.chain(new MessageProcessor[]{choiceRouter});
        builder.chain(new MessageProcessor[]{new ResponseMessageProcessorAdapter((MessageProcessor)new ObjectToJson())});
    }

    protected Filter getJsonFilter() {
        Filter formFilter = new Filter(){

            public boolean accept(MuleMessage msg) {
                Object ct = msg.getInboundProperty("Content-Type");
                String method = (String)msg.getInboundProperty("http.method");
                return ct == null && (method == null || !method.toUpperCase().equals("GET")) || ct != null && ct.toString().contains("application/json");
            }
        };
        return formFilter;
    }

    protected Filter getFormFilter() {
        Filter formFilter = new Filter(){

            public boolean accept(MuleMessage msg) {
                Object ct = msg.getInboundProperty("Content-Type");
                return ct != null && ct.toString().contains("multipart/form-data");
            }
        };
        return formFilter;
    }

    public String getConstructType() {
        return "Query-Service";
    }
}

