/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mql.impl;

import com.mulesoft.mql.JoinBuilder;
import com.mulesoft.mql.ObjectBuilder;
import com.mulesoft.mql.Query;
import com.mulesoft.mql.QueryBuilder;
import com.mulesoft.mql.Restriction;
import com.mulesoft.mql.grammar.analysis.DepthFirstAdapter;
import com.mulesoft.mql.grammar.node.AAndWhereExpression;
import com.mulesoft.mql.grammar.node.AAsStatement;
import com.mulesoft.mql.grammar.node.AAsyncAsyncStatement;
import com.mulesoft.mql.grammar.node.AClassParens;
import com.mulesoft.mql.grammar.node.AEqualsComparator;
import com.mulesoft.mql.grammar.node.AFullQuery;
import com.mulesoft.mql.grammar.node.AGtComparator;
import com.mulesoft.mql.grammar.node.AGteComparator;
import com.mulesoft.mql.grammar.node.AJoinJoinStatement;
import com.mulesoft.mql.grammar.node.ALikeComparator;
import com.mulesoft.mql.grammar.node.ALtComparator;
import com.mulesoft.mql.grammar.node.ALteComparator;
import com.mulesoft.mql.grammar.node.ANotEqualsComparator;
import com.mulesoft.mql.grammar.node.AOnStatement;
import com.mulesoft.mql.grammar.node.AOrWhereExpression;
import com.mulesoft.mql.grammar.node.ASelectMvelPropertySelectNewItemProperty;
import com.mulesoft.mql.grammar.node.ASelectNewObjectSelectNewItemProperty;
import com.mulesoft.mql.grammar.node.ASelectNewSelectStatement;
import com.mulesoft.mql.grammar.node.ASelectOnlyQuery;
import com.mulesoft.mql.grammar.node.ASyncAsyncStatement;
import com.mulesoft.mql.grammar.node.AThreadStatement;
import com.mulesoft.mql.grammar.node.AVariableWhereSide;
import com.mulesoft.mql.grammar.node.AWhereClause;
import com.mulesoft.mql.grammar.node.PWhereSide;
import java.util.Stack;

public class MqlInterpreter
extends DepthFirstAdapter {
    private QueryBuilder queryBuilder;
    private Stack<Restriction> restrictions = new Stack();
    private Stack<ObjectBuilder> objectBuilder = new Stack();
    private JoinBuilder join;
    private String transformClass;

    public void caseAFullQuery(AFullQuery node) {
        this.queryBuilder = new QueryBuilder();
        this.queryBuilder.from(this.parseSpaces(node.getFromvar().toString()));
        super.caseAFullQuery(node);
        if (this.restrictions.size() == 1) {
            this.queryBuilder.where(this.restrictions.pop());
        } else if (this.restrictions.size() > 0) {
            throw new IllegalStateException("Too many restrictions!");
        }
    }

    public void caseAAsStatement(AAsStatement node) {
        this.queryBuilder.as(node.getAsvar().getText());
        super.caseAAsStatement(node);
    }

    public void caseASelectOnlyQuery(ASelectOnlyQuery node) {
        this.queryBuilder = new QueryBuilder();
        super.caseASelectOnlyQuery(node);
    }

    public void inAJoinJoinStatement(AJoinJoinStatement node) {
        this.join = JoinBuilder.expression(this.parseSpaces(node.getJoinexpression().toString()), node.getAsvar().getText());
        this.queryBuilder.join(this.join);
        super.inAJoinJoinStatement(node);
    }

    public void caseAOnStatement(AOnStatement node) {
        this.join.on(this.parseSpaces(node.getOnExpression().toString()));
        super.caseAOnStatement(node);
    }

    public void caseAAsyncAsyncStatement(AAsyncAsyncStatement node) {
        this.join.async();
        super.caseAAsyncAsyncStatement(node);
    }

    public void outASyncAsyncStatement(ASyncAsyncStatement node) {
        this.join.sync();
        super.outASyncAsyncStatement(node);
    }

    public void caseAThreadStatement(AThreadStatement node) {
        this.join.threads(Integer.valueOf(node.getThreadCount().toString().trim()));
        super.caseAThreadStatement(node);
    }

    public void caseAOrWhereExpression(AOrWhereExpression node) {
        super.caseAOrWhereExpression(node);
        Restriction right = this.restrictions.pop();
        Restriction left = this.restrictions.pop();
        this.restrictions.add(Restriction.or(left, right));
    }

    public void caseAAndWhereExpression(AAndWhereExpression node) {
        super.caseAAndWhereExpression(node);
        Restriction right = this.restrictions.pop();
        Restriction left = this.restrictions.pop();
        this.restrictions.add(Restriction.and(left, right));
    }

    public void caseAWhereClause(AWhereClause node) {
        Object leftObj = this.getRestrictedObject(node.getLeft());
        Object rightObj = this.getRestrictedObject(node.getRight());
        if (node.getComparator() instanceof AEqualsComparator) {
            this.restrictions.add(Restriction.eq(leftObj, rightObj));
        } else if (node.getComparator() instanceof ALtComparator) {
            this.restrictions.add(Restriction.lt(leftObj, rightObj));
        } else if (node.getComparator() instanceof ALteComparator) {
            this.restrictions.add(Restriction.lte(leftObj, rightObj));
        } else if (node.getComparator() instanceof AGtComparator) {
            this.restrictions.add(Restriction.gt(leftObj, rightObj));
        } else if (node.getComparator() instanceof AGteComparator) {
            this.restrictions.add(Restriction.gte(leftObj, rightObj));
        } else if (node.getComparator() instanceof ALikeComparator) {
            this.restrictions.add(Restriction.like(leftObj, rightObj));
        } else if (node.getComparator() instanceof ANotEqualsComparator) {
            this.restrictions.add(Restriction.not(Restriction.eq(leftObj, rightObj)));
        } else {
            throw new IllegalStateException("unsupported comparator " + node.getComparator().getClass().getName());
        }
        super.caseAWhereClause(node);
    }

    private Object getRestrictedObject(PWhereSide parsed) {
        String side = parsed.toString().trim();
        if (parsed instanceof AVariableWhereSide) {
            side = side.replace(" ", "");
            return Restriction.property(side);
        }
        return side.substring(1, side.length() - 1);
    }

    public void caseASelectNewSelectStatement(ASelectNewSelectStatement node) {
        if (this.queryBuilder.getSelect() == null) {
            this.objectBuilder.push(ObjectBuilder.newObject());
            this.queryBuilder.select(this.objectBuilder.peek());
        }
        super.caseASelectNewSelectStatement(node);
    }

    public void caseAClassParens(AClassParens node) {
        if (node.getClassName() != null) {
            this.objectBuilder.peek().setTransformClass(this.parseSpaces(node.getClassName().toString()));
        }
        super.caseAClassParens(node);
    }

    public void inASelectMvelPropertySelectNewItemProperty(ASelectMvelPropertySelectNewItemProperty node) {
        String javaExpression = node.getEqualsExpression().toString();
        javaExpression = this.parseSpaces(javaExpression);
        this.objectBuilder.peek().set(node.getIdentifier().getText(), javaExpression);
        super.inASelectMvelPropertySelectNewItemProperty(node);
    }

    public void inASelectNewObjectSelectNewItemProperty(ASelectNewObjectSelectNewItemProperty node) {
        ObjectBuilder current = this.objectBuilder.peek();
        ObjectBuilder next = this.objectBuilder.push(ObjectBuilder.newObject());
        current.set(node.getIdentifier().getText(), next);
        super.inASelectNewObjectSelectNewItemProperty(node);
    }

    public void outASelectNewObjectSelectNewItemProperty(ASelectNewObjectSelectNewItemProperty node) {
        super.outASelectNewObjectSelectNewItemProperty(node);
        this.objectBuilder.pop();
    }

    private String parseSpaces(String expr) {
        int start = 0;
        return this.parseSpaces(expr, start);
    }

    private String parseSpaces(String expr, int start) {
        int quoteStart = this.getNextQuoteIndex(expr, start);
        int quoteEnd = this.getNextQuoteIndex(expr, quoteStart + 1);
        if (quoteStart == -1) {
            return expr.substring(0, start) + expr.substring(start).replace(" ", "");
        }
        if (quoteEnd == -1) {
            return expr;
        }
        String part1 = expr.substring(0, start);
        String part2 = expr.substring(start, quoteStart).replace(" ", "");
        String part3 = expr.substring(quoteStart);
        String newExpr = part1 + part2 + part3;
        int newStart = this.getNextQuoteIndex(part3, 1) + part1.length() + part2.length() + 1;
        if (newStart == expr.length()) {
            return newExpr;
        }
        return this.parseSpaces(newExpr, newStart);
    }

    protected int getNextQuoteIndex(String expr, int start) {
        int quoteStart = expr.indexOf(39, start);
        if (quoteStart != -1 && expr.charAt(quoteStart - 1) == '\\') {
            return this.getNextQuoteIndex(expr, quoteStart + 1);
        }
        return quoteStart;
    }

    public void caseALtComparator(ALtComparator node) {
        super.caseALtComparator(node);
    }

    public Query getQuery() {
        return this.queryBuilder.build();
    }
}

