/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MuleVersion {
    private static final Pattern pattern = Pattern.compile("([0-9]+)(\\.)([0-9]+)(\\.([0-9]*))?(-(.+))?");
    private int major = 0;
    private int minor = 0;
    private int revision = -1;
    private String suffix;

    public MuleVersion(String version) {
        this.parse(version);
    }

    public String toString() {
        StringBuilder v = new StringBuilder(this.major + "." + this.minor);
        if (this.revision >= 0) {
            v.append(".").append(this.revision);
        }
        if (this.suffix != null && this.suffix.trim().length() > 0) {
            v.append("-").append(this.suffix);
        }
        return v.toString();
    }

    private void parse(String version) {
        Matcher m = pattern.matcher(version);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid version " + version);
        }
        try {
            this.major = Integer.parseInt(m.group(1));
            this.minor = Integer.parseInt(m.group(3));
            if (m.group(4) != null && m.group(4).startsWith(".")) {
                this.revision = Integer.parseInt(m.group(5));
            }
            if (m.group(6) != null && m.group(6).startsWith("-")) {
                this.suffix = m.group(7);
            }
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid version " + version);
        }
        if (!this.toString().equals(version)) {
            throw new IllegalArgumentException("Invalid version " + version);
        }
    }

    public boolean atLeast(String version) {
        return this.atLeast(new MuleVersion(version));
    }

    public boolean atLeast(MuleVersion version) {
        return this.equals(version) || this.newerThan(version);
    }

    public boolean atLeastBase(String baseVersion) {
        return this.getBaseVersion().atLeastBase(new MuleVersion(baseVersion));
    }

    public boolean atLeastBase(MuleVersion baseVersion) {
        return this.getBaseVersion().atLeast(baseVersion.getBaseVersion());
    }

    public boolean sameAs(String version) {
        return this.sameAs(new MuleVersion(version));
    }

    public boolean sameAs(MuleVersion version) {
        return this.equals(version);
    }

    public boolean priorTo(String version) {
        return this.priorTo(new MuleVersion(version));
    }

    public boolean priorTo(MuleVersion version) {
        return !this.atLeast(version);
    }

    public boolean newerThan(String version) {
        return this.newerThan(new MuleVersion(version));
    }

    public boolean newerThan(MuleVersion version) {
        if (this.getMajor() > version.getMajor()) {
            return true;
        }
        if (this.getMajor() == version.getMajor()) {
            if (this.getMinor() > version.getMinor()) {
                return true;
            }
            if (this.getMinor() == version.getMinor()) {
                if (this.getRevision() > version.getRevision()) {
                    return true;
                }
                if (this.getRevision() == version.getRevision() || this.getRevision() <= 0 && version.getRevision() <= 0) {
                    if (!this.hasSuffix() && version.hasSuffix()) {
                        return true;
                    }
                    if (this.hasSuffix() && version.hasSuffix()) {
                        return this.getSuffix().compareToIgnoreCase(version.getSuffix()) > 0;
                    }
                }
            }
        }
        return false;
    }

    public String toCompleteNumericVersion() {
        StringBuilder v = new StringBuilder(this.major + "." + this.minor + ".");
        if (this.revision >= 0) {
            v.append(this.revision);
        } else {
            v.append("0");
        }
        return v.toString();
    }

    public boolean hasSuffix() {
        return this.getSuffix() != null && this.getSuffix().length() > 0;
    }

    private MuleVersion getBaseVersion() {
        return new MuleVersion(this.getMajor() + "." + this.getMinor());
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof MuleVersion)) {
            return false;
        }
        return this.toString().equals(otherObject.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int getRevision() {
        return this.revision;
    }

    public void setRevision(int revision) {
        this.revision = revision;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }
}

