/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.meta.model.declaration.fluent;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ExternalLibraryModel;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.SubTypesModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SubDeclarationsContainer;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSourcesDeclaration;
import org.mule.runtime.api.meta.model.error.ErrorModel;

public class ExtensionDeclaration
extends NamedDeclaration<ExtensionDeclaration>
implements ConnectedDeclaration<ExtensionDeclaration>,
WithSourcesDeclaration<ExtensionDeclaration>,
WithOperationsDeclaration<ExtensionDeclaration> {
    private final List<ConfigurationDeclaration> configurations = new LinkedList<ConfigurationDeclaration>();
    private final SubDeclarationsContainer subDeclarations = new SubDeclarationsContainer();
    private String name;
    private String version;
    private String vendor;
    private Category category;
    private MuleVersion minMuleVersion;
    private Set<ObjectType> types = new LinkedHashSet<ObjectType>();
    private XmlDslModel xmlDslModel;
    private Map<MetadataType, Set<MetadataType>> subTypes = new LinkedHashMap<MetadataType, Set<MetadataType>>();
    private Set<ImportedTypeModel> importedTypes = new LinkedHashSet<ImportedTypeModel>();
    private Set<String> resources = new LinkedHashSet<String>();
    private Set<ErrorModel> errorModels = new LinkedHashSet<ErrorModel>();
    private Set<ExternalLibraryModel> externalLibraryModels = new LinkedHashSet<ExternalLibraryModel>();

    ExtensionDeclaration() {
        super("");
    }

    public List<ConfigurationDeclaration> getConfigurations() {
        return this.configurations;
    }

    public ExtensionDeclaration addConfig(ConfigurationDeclaration config) {
        if (config == null) {
            throw new IllegalArgumentException("Can't add a null config");
        }
        this.configurations.add(config);
        return this;
    }

    @Override
    public List<OperationDeclaration> getOperations() {
        return this.subDeclarations.getOperations();
    }

    @Override
    public List<ConnectionProviderDeclaration> getConnectionProviders() {
        return this.subDeclarations.getConnectionProviders();
    }

    @Override
    public List<SourceDeclaration> getMessageSources() {
        return this.subDeclarations.getMessageSources();
    }

    @Override
    public ExtensionDeclaration addConnectionProvider(ConnectionProviderDeclaration connectionProvider) {
        this.subDeclarations.addConnectionProvider(connectionProvider);
        return this;
    }

    @Override
    public ExtensionDeclaration addOperation(OperationDeclaration operation) {
        this.subDeclarations.addOperation(operation);
        return this;
    }

    @Override
    public ExtensionDeclaration addMessageSource(SourceDeclaration sourceDeclaration) {
        this.subDeclarations.addMessageSource(sourceDeclaration);
        return this;
    }

    public Set<ObjectType> getTypes() {
        return Collections.unmodifiableSet(this.types);
    }

    public Set<String> getResources() {
        return Collections.unmodifiableSet(this.resources);
    }

    public ExtensionDeclaration addType(ObjectType objectType) {
        this.types.add(objectType);
        return this;
    }

    public ExtensionDeclaration addResource(String resourcePath) {
        this.resources.add(resourcePath);
        return this;
    }

    public ExtensionDeclaration addImportedType(ImportedTypeModel importedType) {
        this.importedTypes.add(importedType);
        return this;
    }

    public ExtensionDeclaration addExternalLibrary(ExternalLibraryModel externalLibraryModel) {
        this.externalLibraryModels.add(externalLibraryModel);
        return this;
    }

    public void addSubtype(MetadataType baseType, MetadataType subType) {
        Set items = this.subTypes.computeIfAbsent(baseType, key -> new LinkedHashSet());
        items.add(subType);
    }

    public void addSubtypes(MetadataType baseType, Collection<MetadataType> subTypes) {
        Set items = this.subTypes.computeIfAbsent(baseType, key -> new LinkedHashSet());
        items.addAll(subTypes);
    }

    public Set<SubTypesModel> getSubTypes() {
        return this.subTypes.entrySet().stream().map(entry -> new SubTypesModel((MetadataType)entry.getKey(), (Set)entry.getValue())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<ExternalLibraryModel> getExternalLibraryModels() {
        return this.externalLibraryModels;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    void setVersion(String version) {
        this.version = version;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public MuleVersion getMinMuleVersion() {
        return this.minMuleVersion;
    }

    public void setMinMuleVersion(MuleVersion minMuleVersion) {
        this.minMuleVersion = minMuleVersion;
    }

    public XmlDslModel getXmlDslModel() {
        return this.xmlDslModel;
    }

    public void setXmlDslModel(XmlDslModel xmlDslModel) {
        this.xmlDslModel = xmlDslModel;
    }

    public Set<ImportedTypeModel> getImportedTypes() {
        return this.importedTypes;
    }

    public void addErrorModel(ErrorModel errorModel) {
        this.errorModels.add(errorModel);
    }

    public Set<ErrorModel> getErrorModels() {
        return this.errorModels;
    }
}

