/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.meta.model.declaration.fluent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.util.Preconditions;

public abstract class ParameterizedDeclaration<T extends ParameterizedDeclaration>
extends NamedDeclaration<T> {
    private final Map<String, ParameterGroupDeclaration> parameterGroups = new HashMap<String, ParameterGroupDeclaration>();

    ParameterizedDeclaration(String name) {
        super(name);
    }

    public List<ParameterGroupDeclaration> getParameterGroups() {
        return Collections.unmodifiableList(new ArrayList<ParameterGroupDeclaration>(this.parameterGroups.values()));
    }

    public ParameterGroupDeclaration getParameterGroup(String groupName) {
        Preconditions.checkArgument(!StringUtils.isBlank((CharSequence)groupName), "groupName cannot be blank");
        return this.parameterGroups.computeIfAbsent(groupName, ParameterGroupDeclaration::new);
    }

    public List<ParameterDeclaration> getAllParameters() {
        return this.parameterGroups.values().stream().flatMap(g -> g.getParameters().stream()).collect(Collectors.toList());
    }
}

