/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.meta.model.util;

import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.connection.HasConnectionProviderModels;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.util.Preconditions;

public abstract class ExtensionWalker {
    private boolean stopped;

    public final void walk(ExtensionModel extensionModel) {
        Preconditions.checkArgument(extensionModel != null, "Cannot walk a null model");
        this.stopped = false;
        for (ConfigurationModel model : extensionModel.getConfigurationModels()) {
            if (this.stopped) {
                return;
            }
            this.onConfiguration(model);
            this.ifContinue(() -> this.walkConnectionProviders(model));
            this.ifContinue(() -> this.walkParameters(model));
            this.ifContinue(() -> this.walkSources(model));
            this.ifContinue(() -> this.walkOperations(model));
        }
        this.ifContinue(() -> this.walkConnectionProviders(extensionModel));
        this.ifContinue(() -> this.walkSources(extensionModel));
        this.ifContinue(() -> this.walkOperations(extensionModel));
    }

    protected final void stop() {
        this.stopped = true;
    }

    protected void onConfiguration(ConfigurationModel model) {
    }

    protected void onOperation(HasOperationModels owner, OperationModel model) {
    }

    protected void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
    }

    protected void onSource(HasSourceModels owner, SourceModel model) {
    }

    protected void onParameterGroup(ParameterizedModel owner, ParameterGroupModel model) {
    }

    protected void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, ParameterModel model) {
    }

    private void walkSources(HasSourceModels model) {
        for (SourceModel source : model.getSourceModels()) {
            if (this.stopped) {
                return;
            }
            this.onSource(model, source);
            this.ifContinue(() -> this.walkParameters(source));
            this.ifContinue(() -> source.getSuccessCallback().ifPresent(this::walkParameters));
            this.ifContinue(() -> source.getErrorCallback().ifPresent(this::walkParameters));
        }
    }

    private void walkParameters(ParameterizedModel model) {
        for (ParameterGroupModel group : model.getParameterGroupModels()) {
            if (this.stopped) {
                return;
            }
            this.onParameterGroup(model, group);
            this.ifContinue(() -> this.walkGroupParameters(model, group));
        }
    }

    private void walkGroupParameters(ParameterizedModel model, ParameterGroupModel group) {
        for (ParameterModel p : group.getParameterModels()) {
            if (this.stopped) {
                return;
            }
            this.onParameter(model, group, p);
        }
    }

    private void walkConnectionProviders(HasConnectionProviderModels model) {
        for (ConnectionProviderModel provider : model.getConnectionProviders()) {
            if (this.stopped) {
                return;
            }
            this.onConnectionProvider(model, provider);
            this.ifContinue(() -> this.walkParameters(provider));
        }
    }

    private void walkOperations(HasOperationModels model) {
        for (OperationModel operation : model.getOperationModels()) {
            if (this.stopped) {
                return;
            }
            this.onOperation(model, operation);
            this.ifContinue(() -> this.walkParameters(operation));
        }
    }

    private void ifContinue(Runnable action) {
        if (!this.stopped) {
            action.run();
        }
    }
}

