/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.app.declaration.serialization.adapter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.List;
import org.mule.runtime.api.app.declaration.ParameterValue;
import org.mule.runtime.api.app.declaration.ParameterValueVisitor;
import org.mule.runtime.api.app.declaration.fluent.ParameterListValue;
import org.mule.runtime.api.app.declaration.fluent.ParameterObjectValue;
import org.mule.runtime.api.app.declaration.fluent.ParameterSimpleValue;

public class ParameterValueTypeAdapter
extends TypeAdapter<ParameterValue> {
    private static final String TYPE_ID = "typeId";

    public void write(JsonWriter jsonWriter, ParameterValue parameter) throws IOException {
        if (parameter != null) {
            parameter.accept(this.getValueVisitor(jsonWriter));
        }
    }

    public ParameterValue read(JsonReader in) throws IOException {
        if (in != null) {
            JsonElement parse = new JsonParser().parse(in);
            return this.getParameterValue(parse);
        }
        return null;
    }

    private ParameterValueVisitor getValueVisitor(final JsonWriter jsonWriter) {
        return new ParameterValueVisitor(){

            @Override
            public void visitSimpleValue(String value) {
                ParameterValueTypeAdapter.this.writeSimpleValue(value, jsonWriter);
            }

            @Override
            public void visitListValue(ParameterListValue list) {
                ParameterValueTypeAdapter.this.writeListValue(list, jsonWriter);
            }

            @Override
            public void visitObjectValue(ParameterObjectValue objectValue) {
                ParameterValueTypeAdapter.this.writeObjectValue(objectValue, jsonWriter);
            }
        };
    }

    private void writeObjectValue(ParameterObjectValue objectValue, JsonWriter jsonWriter) {
        try {
            JsonWriter object = jsonWriter.beginObject();
            objectValue.getParameters().forEach((name, v) -> {
                try {
                    JsonWriter field = object.name(name);
                    v.accept(this.getValueVisitor(field));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            if (objectValue.getTypeId() != null && !objectValue.getTypeId().trim().isEmpty()) {
                object.name(TYPE_ID).value(objectValue.getTypeId());
            }
            object.endObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeListValue(ParameterListValue list, JsonWriter jsonWriter) {
        List<ParameterValue> values = list.getValues();
        try {
            JsonWriter array = jsonWriter.beginArray();
            values.forEach(v -> v.accept(this.getValueVisitor(array)));
            array.endArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeSimpleValue(String value, JsonWriter jsonWriter) {
        try {
            jsonWriter.value(value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ParameterValue getParameterValue(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            String value = jsonElement.getAsString();
            return ParameterSimpleValue.of(value);
        }
        if (jsonElement.isJsonArray()) {
            JsonArray array = jsonElement.getAsJsonArray();
            ParameterListValue.Builder listBuilder = ParameterListValue.builder();
            array.forEach(e -> listBuilder.withValue(this.getParameterValue((JsonElement)e)));
            return listBuilder.build();
        }
        if (jsonElement.isJsonObject()) {
            JsonObject object = jsonElement.getAsJsonObject();
            ParameterObjectValue.Builder objectBuilder = ParameterObjectValue.builder();
            object.entrySet().forEach(field -> {
                if (((String)field.getKey()).equals(TYPE_ID)) {
                    objectBuilder.ofType(((JsonElement)field.getValue()).getAsString());
                } else {
                    objectBuilder.withParameter((String)field.getKey(), this.getParameterValue((JsonElement)field.getValue()));
                }
            });
            return objectBuilder.build();
        }
        return null;
    }
}

