/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.component;

import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.util.Preconditions;

class DefaultTypedComponentIdentifier
implements TypedComponentIdentifier {
    private ComponentIdentifier identifier;
    private TypedComponentIdentifier.ComponentType type;

    private DefaultTypedComponentIdentifier() {
    }

    @Override
    public ComponentIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public TypedComponentIdentifier.ComponentType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultTypedComponentIdentifier that = (DefaultTypedComponentIdentifier)o;
        if (!this.getIdentifier().equals(that.getIdentifier())) {
            return false;
        }
        return this.getType() == that.getType();
    }

    public int hashCode() {
        int result = this.getIdentifier().hashCode();
        result = 31 * result + this.getType().hashCode();
        return result;
    }

    public static class Builder
    implements TypedComponentIdentifier.Builder {
        private DefaultTypedComponentIdentifier typedComponentIdentifier = new DefaultTypedComponentIdentifier();

        @Override
        public TypedComponentIdentifier.Builder withIdentifier(ComponentIdentifier identifier) {
            this.typedComponentIdentifier.identifier = identifier;
            return this;
        }

        @Override
        public Builder withType(TypedComponentIdentifier.ComponentType type) {
            this.typedComponentIdentifier.type = type;
            return this;
        }

        @Override
        public TypedComponentIdentifier build() {
            Preconditions.checkState(this.typedComponentIdentifier.identifier != null, "identifier cannot be null");
            Preconditions.checkState(this.typedComponentIdentifier.type != null, "type cannot be null");
            return this.typedComponentIdentifier;
        }
    }
}

