/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.meta.model.declaration.fluent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;

final class SubDeclarationsContainer {
    private final Set<OperationDeclaration> operations = new LinkedHashSet<OperationDeclaration>();
    private final List<ConnectionProviderDeclaration> connectionProviders = new LinkedList<ConnectionProviderDeclaration>();
    private final List<SourceDeclaration> messageSources = new LinkedList<SourceDeclaration>();

    SubDeclarationsContainer() {
    }

    public List<OperationDeclaration> getOperations() {
        return Collections.unmodifiableList(new ArrayList<OperationDeclaration>(this.operations));
    }

    public List<ConnectionProviderDeclaration> getConnectionProviders() {
        return Collections.unmodifiableList(this.connectionProviders);
    }

    public List<SourceDeclaration> getMessageSources() {
        return Collections.unmodifiableList(this.messageSources);
    }

    public void addConnectionProvider(ConnectionProviderDeclaration connectionProvider) {
        if (connectionProvider == null) {
            throw new IllegalArgumentException("Can't add a null connection provider");
        }
        this.connectionProviders.add(connectionProvider);
    }

    public void addOperation(OperationDeclaration operation) {
        if (operation == null) {
            throw new IllegalArgumentException("Can't add a null operation");
        }
        this.operations.add(operation);
    }

    public void addMessageSource(SourceDeclaration sourceDeclaration) {
        if (sourceDeclaration == null) {
            throw new IllegalArgumentException("Can't add a null message source");
        }
        this.messageSources.add(sourceDeclaration);
    }
}

