/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.api;

import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.api.util.Preconditions;

public class ComponentPath {
    public static final char PATH_SEPARATOR = '/';
    public static final String SOURCE = "source";
    private final String[] path;

    public static ComponentPath valueOf(String componentPath) {
        Preconditions.checkNotNull((Object)componentPath, (String)"missing componentPath");
        return new ComponentPath(StringUtils.split((String)componentPath, (char)'/'));
    }

    public static boolean isSource(ComponentPath componentPath) {
        if (componentPath == null || componentPath.getPath().length < 2) {
            return false;
        }
        return SOURCE.equals(componentPath.getPath()[componentPath.getPath().length - 1]);
    }

    public static ComponentPath valueOf(ComponentPath componentPath, String name) {
        Preconditions.checkNotNull((Object)componentPath, (String)"missing componentPath");
        Preconditions.checkNotNull((Object)name, (String)"missing name");
        return new ComponentPath((String[])ArrayUtils.add((Object[])componentPath.getPath(), (Object)name));
    }

    public ComponentPath(String ... path) {
        Preconditions.checkNotNull((Object)path, (String)"missing path");
        Preconditions.checkArgument((!Arrays.stream(path).anyMatch(s -> s.isEmpty() || s.contains(String.valueOf('/'))) ? 1 : 0) != 0, (String)String.format("provided path %s is invalid", Arrays.toString(path)));
        this.path = (String[])ArrayUtils.clone((Object[])path);
    }

    private String[] getPath() {
        return this.path;
    }

    public boolean isRoot() {
        return this.path.length == 0;
    }

    public static ComponentPath getFlowPath(ComponentPath componentPath) {
        Preconditions.checkNotNull((Object)componentPath, (String)"missing componentPath");
        Preconditions.checkState((!componentPath.isRoot() ? 1 : 0) != 0, (String)"componentPath is root");
        return new ComponentPath(componentPath.path[0]);
    }

    public static String getFlow(ComponentPath componentPath) {
        Preconditions.checkNotNull((Object)componentPath, (String)"missing componentPath");
        Preconditions.checkState((!componentPath.isRoot() ? 1 : 0) != 0, (String)"componentPath is root");
        return componentPath.path[0];
    }

    public static ComponentPath getFlowRelativeSubPath(ComponentPath componentPath) {
        Preconditions.checkNotNull((Object)componentPath, (String)"missing componentPath");
        Preconditions.checkState((componentPath.path.length > 1 ? 1 : 0) != 0, (String)"componentPath size <= 1");
        return new ComponentPath((String[])ArrayUtils.subarray((Object[])componentPath.path, (int)1, (int)componentPath.path.length));
    }

    public String toString() {
        return StringUtils.join((Object[])this.path, (String)"/");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentPath that = (ComponentPath)o;
        return Arrays.equals(this.path, that.path);
    }

    public int hashCode() {
        return Arrays.hashCode(this.path);
    }
}

