/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.datasense.api;

import org.mule.datasense.api.notifications.DataSenseNotification;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 *
 */
public interface DataSenseInfo {

  Location getLocation();

  /**
   *
   * @return
   */
  Optional<MetadataType> getInput();

  /**
   *
   * @return
   */
  Optional<MetadataType> getOutput();

  /**
   *
   * @return
   */
  Optional<MetadataType> getIncoming();

  /**
   *
   * @return
   */
  Optional<MetadataType> getExpected();


  /**
   *
   * @return
   */
  Optional<MetadataType> getActualInput();

  /**
   *
   * @return
   */
  Optional<MetadataType> getActualOutput();

  /**
   *
   * @return
   */
  Optional<MetadataType> getExpectedInput();

  /**
   *
   * @return
   */
  Optional<MetadataType> getExpectedOutput();

  /**
   *
   * @return
   */
  Optional<MetadataType> getResult();

  /**
   *
   * @return
     */
  Optional<OperationModel> getOperationModel();

  /**
   *
   * @return
     */
  Optional<SourceModel> getSourceModel();

  /**
   *
   * @return
   */
  List<String> getMessages();

  /**
   *
   * @return
   */
  List<DataSenseNotification> getDataSenseNotifications();

  /**
   *
   * @return
   */
  Optional<Map<Location, DataSenseElementInfo>> getComponentInfoByComponentPath();
}
