package org.mule.datasense.api.metadataprovider;

import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataResult;

import java.util.concurrent.Callable;

public interface DataSenseMetadataCacheProvider {

  MetadataResult<ComponentMetadataDescriptor<OperationModel>> getOperationMetadata(String componentId,
                                                                                   Location location, Long timestamp,
                                                                                   Callable<MetadataResult<ComponentMetadataDescriptor<OperationModel>>> callable);

  MetadataResult<ComponentMetadataDescriptor<SourceModel>> getSourceMetadata(String componentId, Location location,
                                                                             Long timestamp,
                                                                             Callable<MetadataResult<ComponentMetadataDescriptor<SourceModel>>> callable);

  MetadataResult<MetadataKeysContainer> getMetadataKeys(String componentId, Location location, Long timestamp,
                                                        Callable<MetadataResult<MetadataKeysContainer>> callable);
}
