package org.mule.datasense.api.metadataprovider;

import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.config.internal.model.ComponentModel;

import java.util.Optional;

import static java.util.Optional.empty;

public class CompatibleComponentAst {

  private ComponentModel componentModel;

  private Object modelInterface;

  private Location componentModelLocation;

  private CompatibleComponentAst(ComponentModel componentModel, Location location) {
    this.componentModel = componentModel;
    this.componentModelLocation = location;
  }

  public CompatibleComponentAst(ComponentModel componentModel,
                                Location location,
                                Object modelInterface) {
    this(componentModel, location);
    setModelInterface(modelInterface);
  }

  public Location getLocation() {
    return componentModelLocation;
  }

  public <M> Optional<M> getModel(Class<M> modelClass) {
    if (componentModel != null) {
      if (modelClass.isAssignableFrom(componentModel.getClass())) {
        return Optional.of((M) componentModel);
      }
    }

    if (modelInterface != null) {
      if (modelClass.isAssignableFrom(modelInterface.getClass())) {
        return Optional.of((M) modelInterface);
      }
    }

    return empty();
  }

  private void setModelInterface(Object modelInterface) {
    this.modelInterface = modelInterface;
  }

}
