package org.mule.datasense.api.metadataprovider;

import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.ast.api.ComponentAst;

import java.util.concurrent.Callable;

public interface DataSenseMetadataCacheProvider {

  MetadataResult<OperationModel> getOperationMetadata(ComponentAst componentAst,
                                                      Callable<MetadataResult<OperationModel>> callable);

  MetadataResult<SourceModel> getSourceMetadata(ComponentAst componentAst, Callable<MetadataResult<SourceModel>> callable);

  MetadataResult<MetadataKeysContainer> getMetadataKeys(ComponentAst componentAst,
                                                        Callable<MetadataResult<MetadataKeysContainer>> callable);
}
