/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.raml;

import java.io.File;
import java.util.List;
import java.util.Optional;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.raml.BaseRamlTypeLoader;
import org.mule.metadata.raml.handler.ParsingContext;
import org.mule.metadata.raml.handler.TypeDeclarationHandlerManager;
import org.raml.v2.api.RamlModelBuilder;
import org.raml.v2.api.RamlModelResult;
import org.raml.v2.api.model.v10.api.Library;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class RamlTypeLibTypeLoader
extends BaseRamlTypeLoader {
    private File ramlTypeLibFile;
    private MetadataFormat metadataFormat;

    public RamlTypeLibTypeLoader(File ramlTypeLibFile, MetadataFormat metadataFormat) {
        this.ramlTypeLibFile = ramlTypeLibFile;
        this.metadataFormat = metadataFormat;
    }

    public Optional<MetadataType> load(String typeIdentifier) {
        return this.load(typeIdentifier, null);
    }

    public Optional<MetadataType> load(String typeIdentifier, String typeAlias) {
        try {
            RamlModelResult ramlModelResult = new RamlModelBuilder().buildApi(this.ramlTypeLibFile);
            Library library = ramlModelResult.getLibrary();
            List types = library.types();
            return Optional.ofNullable(types.stream().filter(typeDeclaration -> typeDeclaration.name().equals(typeIdentifier)).findFirst().map(typeDeclaration -> {
                TypeDeclarationHandlerManager typeDeclarationHandlerManager = new TypeDeclarationHandlerManager(this.metadataFormat);
                TypeBuilder<?> typeBuilder = typeDeclarationHandlerManager.handle((TypeDeclaration)typeDeclaration, new ParsingContext());
                MetadataTypeUtils.addTypeAlias(typeBuilder, (String)typeAlias);
                return typeBuilder.build();
            }).orElse(null));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

