package org.mule.metadata.raml;

import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.raml.handler.ParsingContext;
import org.mule.metadata.raml.handler.TypeDeclarationHandlerManager;
import org.raml.v2.api.RamlModelBuilder;
import org.raml.v2.api.RamlModelResult;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

import java.io.File;
import java.util.Optional;

public class DataTypeRamlFragmentTypeLoader extends BaseRamlTypeLoader {

  private final RamlLoader ramlLoader;
  private MetadataFormat metadataFormat;

  public DataTypeRamlFragmentTypeLoader(File file, MetadataFormat metadataFormat) {
    this.ramlLoader = new FileRamlLoader(file);
    this.metadataFormat = metadataFormat;
  }

  public DataTypeRamlFragmentTypeLoader(String content, MetadataFormat metadataFormat) {
    this.ramlLoader = new StringRamlLoader(content);
    this.metadataFormat = metadataFormat;
  }

  private interface RamlLoader {

    RamlModelResult load();
  }


  private static class FileRamlLoader implements RamlLoader {

    private final File ramlFile;

    public FileRamlLoader(File ramlFile) {
      this.ramlFile = ramlFile;
    }

    @Override
    public RamlModelResult load() {
      return new RamlModelBuilder().buildApi(ramlFile);
    }
  }


  private static class StringRamlLoader implements RamlLoader {

    private final String content;

    public StringRamlLoader(String content) {
      this.content = content;
    }

    @Override
    public RamlModelResult load() {
      return new RamlModelBuilder().buildApi(content, "");
    }
  }

  @Override
  public Optional<MetadataType> load(String typeIdentifier) {
    return load(typeIdentifier, null);
  }

  @Override
  public Optional<MetadataType> load(String typeIdentifier, String typeAlias) {
    try {
      final RamlModelResult ramlModelResult = ramlLoader.load();
      final TypeDeclaration typeDeclaration = ramlModelResult.getTypeDeclaration();
      final TypeDeclarationHandlerManager typeDeclarationHandlerManager = new TypeDeclarationHandlerManager(metadataFormat);
      final TypeBuilder<?> typeBuilder = typeDeclarationHandlerManager.handle(typeDeclaration, new ParsingContext());
      MetadataTypeUtils.addTypeAlias(typeBuilder, typeAlias);
      return Optional.of(typeBuilder.build());
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }
}
