package org.mule.metadata.raml;

import org.mule.metadata.api.TypeLoader;
import org.raml.v2.api.RamlModelResult;

abstract class BaseRamlTypeLoader implements TypeLoader {

  protected String collectValidationErrors(RamlModelResult ramlModelResult) {
    StringBuilder stringBuilder = new StringBuilder();
    stringBuilder.append("RAML validation errors:\n");
    ramlModelResult.getValidationResults().forEach(validationResult -> {
      stringBuilder.append(String.format("%s: %s.\n", validationResult.getPath(), validationResult.getMessage()));
    });
    return stringBuilder.toString();
  }
}
