package org.mule.metadata.raml.handler;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.NumberTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.raml.v2.api.model.v10.datamodel.NumberTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

import java.util.List;
import java.util.Optional;

public class NumberTypeDeclarationHandler implements TypeDeclarationHandler {

  @Override
  public boolean handles(TypeDeclaration typeDeclaration) {
    return typeDeclaration instanceof NumberTypeDeclaration;
  }

  @Override
  public TypeBuilder<?> handle(TypeDeclaration typeDeclaration, BaseTypeBuilder root,
                               TypeDeclarationHandlerManager typeDeclarationHandlerManager,
                               ParsingContext parsingContext) {
    NumberTypeDeclaration numberTypeDeclaration = (NumberTypeDeclaration) typeDeclaration;
    final NumberTypeBuilder numberTypeBuilder = root.numberType();

    //@todo numberTypeDeclaration.format();

    final Optional<Number> maximum = Optional.ofNullable(numberTypeDeclaration.maximum());
    final Optional<Number> minimum = Optional.ofNullable(numberTypeDeclaration.minimum());
    if (maximum.isPresent() && minimum.isPresent()) {
      numberTypeBuilder.range(minimum.get(), maximum.get());
    }

    final List<Number> enumValues = numberTypeDeclaration.enumValues();
    if (enumValues != null && enumValues.size() > 0) {
      numberTypeBuilder.enumOf(enumValues.toArray(new Number[enumValues.size()]));
    }

    return numberTypeBuilder;
  }
}
