package org.mule.metadata.raml.handler;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class ObjectTypeDeclarationHandler implements TypeDeclarationHandler {

  @Override
  public boolean handles(TypeDeclaration typeDeclaration) {
    return typeDeclaration instanceof ObjectTypeDeclaration;
  }

  @Override
  public TypeBuilder<?> handle(TypeDeclaration typeDeclaration, BaseTypeBuilder root,
                               TypeDeclarationHandlerManager typeDeclarationHandlerManager,
                               ParsingContext parsingContext) {
    final ObjectTypeBuilder objectTypeBuilder = root.objectType();
    ObjectTypeDeclaration objectTypeDeclaration = (ObjectTypeDeclaration) typeDeclaration;
    parsingContext.registerTypeBuilder(objectTypeDeclaration, objectTypeBuilder);
    objectTypeDeclaration.properties().forEach(propertyTypeDeclaration -> {
      final ObjectFieldTypeBuilder objectFieldTypeBuilder = objectTypeBuilder.addField();
      objectFieldTypeBuilder.key(propertyTypeDeclaration.name());
      objectFieldTypeBuilder.value(typeDeclarationHandlerManager.handle(propertyTypeDeclaration, parsingContext));
    });
    return objectTypeBuilder;
  }
}
