package org.mule.metadata.dw;

import org.mule.metadata.api.TypeWriter;
import org.mule.metadata.api.model.MetadataType;
import org.mule.weave.v2.el.metadata.WeaveTypeSerializer;

import java.util.Map;

public class DwTypeWriter implements TypeWriter {

  private static final String DEFAULT_TYPE_NAME = "aType";

  private WeaveTypeSerializer createWriter() {
    return new WeaveTypeSerializer();
  }

  @Override
  public String toString(MetadataType metadataType) {
    return createWriter().serialize(metadataType, DEFAULT_TYPE_NAME);
  }

  public String write(MetadataType metadataType, String name) {
    return createWriter().serialize(metadataType, name);
  }

  public String write(Map<String, MetadataType> catalog) {
    return createWriter().serialize(catalog);
  }
}
