/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.raml.handler;

import org.mule.metadata.api.builder.TypeBuilder;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ParsingContext {

  private Map<TypeDeclaration, TypeBuilder<?>> typeBuilders = new HashMap<>();

  public Optional<TypeBuilder<?>> getTypeBuilder(TypeDeclaration typeDeclaration) {
    return Optional.ofNullable(typeBuilders.get(typeDeclaration));
  }

  public boolean isTypeBuilderPresent(TypeDeclaration typeDeclaration) {
    return getTypeBuilder(typeDeclaration).isPresent();
  }

  public void registerTypeBuilder(TypeDeclaration typeDeclaration, TypeBuilder<?> typedObject) {
    if (!typeBuilders.containsKey(typeDeclaration)) {
      typeBuilders.put(typeDeclaration, typedObject);
    }
  }

}
