package org.mule.metadata.dw;

import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;

import java.io.File;

public abstract class DwBasedExampleTypeLoader extends DwBasedTypeLoader {

  public DwBasedExampleTypeLoader(File file) {
    super(file);
  }

  public DwBasedExampleTypeLoader(String content) {
    super(content);
  }

  @Override
  protected TypeLoader createTypeLoader(File file, MetadataFormat metadataFormat) {
    return new DwExampleTypeLoader(file, metadataFormat);
  }

  @Override
  protected TypeLoader createTypeLoader(String content, MetadataFormat metadataFormat) {
    return new DwExampleTypeLoader(content, metadataFormat);
  }
}
