package org.mule.metadata.dw;

import com.google.common.base.Throwables;
import org.mule.metadata.MetadataFormats;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.el.ExpressionLanguageMetadataTypeResolver;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class DwExampleTypeLoader implements TypeLoader {

  private final File file;
  private final MetadataFormat metadataFormat;
  private final String content;
  private ExpressionLanguageMetadataTypeResolver expressionLanguageMetadataTypeResolver =
      ExpressionLanguageMetadataTypeResolver.getInstance(DwExampleTypeLoader.class.getClassLoader());

  public DwExampleTypeLoader(File file, MetadataFormat metadataFormat) {
    this.file = file;
    this.metadataFormat = metadataFormat;
    this.content = null;
  }

  public DwExampleTypeLoader(String content, MetadataFormat metadataFormat) {
    this.metadataFormat = metadataFormat;
    this.file = null;
    this.content = content;
  }

  @Override
  public Optional<MetadataType> load(String typeIdentifier) {
    return load(typeIdentifier, null);
  }

  private InputStream loadInputStream() throws FileNotFoundException {
    if (file != null) {
      return new FileInputStream(file);
    } else if (content != null) {
      return new ByteArrayInputStream(content.getBytes());
    } else {
      throw new RuntimeException(
                                 "Invalid file content specified.");
    }
  }

  @Override
  public Optional<MetadataType> load(String typeIdentifier, String typeAlias) {
    try (InputStream inputStream = loadInputStream()) {
      Map<String, Object> properties = new HashMap<>();
      final MetadataType metadataFromSample =
          expressionLanguageMetadataTypeResolver.getMetadataFromSample(inputStream, properties,
                                                                       MetadataFormats.getMimeType(metadataFormat));
      return Optional.of(metadataFromSample);
    } catch (Exception e) {
      throw Throwables.propagate(e);
    }
  }
}
