/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.map;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.DateType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.raml.DataTypeRamlFragmentTypeLoader;

public class MapTypeLoader
implements TypeLoader {
    private static final List<Class<? extends MetadataType>> validSimpleTypeClasses = Arrays.asList(StringType.class, NumberType.class, BooleanType.class, DateType.class, DateTimeType.class);
    private final DataTypeRamlFragmentTypeLoader dataTypeRamlFragmentTypeLoader;

    public MapTypeLoader(File file) {
        this.dataTypeRamlFragmentTypeLoader = new DataTypeRamlFragmentTypeLoader(file, MetadataFormat.JAVA);
    }

    public MapTypeLoader(String content) {
        this.dataTypeRamlFragmentTypeLoader = new DataTypeRamlFragmentTypeLoader(content, MetadataFormat.JAVA);
    }

    public Optional<MetadataType> load(String typeIdentifier) {
        return this.load(typeIdentifier, null);
    }

    public Optional<MetadataType> load(String typeIdentifier, String typeAlias) {
        return this.dataTypeRamlFragmentTypeLoader.load(typeIdentifier, typeAlias).map(metadataType -> {
            this.validate((MetadataType)metadataType);
            return metadataType;
        });
    }

    private boolean validArrayType(MetadataType metadataType) {
        if (!(metadataType instanceof ArrayType)) {
            return false;
        }
        ArrayType arrayType = (ArrayType)metadataType;
        MetadataType elementType = arrayType.getType();
        return this.validSimpleType(elementType) || this.validObjectType(elementType);
    }

    private boolean validObjectType(MetadataType metadataType) {
        if (!(metadataType instanceof ObjectType)) {
            return false;
        }
        ObjectType objectType = (ObjectType)metadataType;
        for (ObjectFieldType objectFieldType : objectType.getFields()) {
            if (this.validSimpleType((MetadataType)objectFieldType) || this.validObjectType((MetadataType)objectFieldType) || this.validArrayType((MetadataType)objectFieldType)) continue;
            return false;
        }
        return true;
    }

    private boolean validSimpleType(MetadataType metadataType) {
        for (Class<? extends MetadataType> validSimpleTypeClass : validSimpleTypeClasses) {
            if (!validSimpleTypeClass.isAssignableFrom(metadataType.getClass())) continue;
            return true;
        }
        return false;
    }

    private void validate(MetadataType metadataType) {
        if (this.validArrayType(metadataType) || this.validObjectType(metadataType)) {
            throw new RuntimeException("Invalid RAML type for Map format.");
        }
    }

    static {
        System.setProperty("javax.xml.accessExternalDTD", "");
    }
}

