package org.mule.metadata.dw;

import com.google.common.base.Throwables;
import org.mule.metadata.MetadataFormats;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.weave.v2.el.metadata.WeaveTypeLoader;
import org.raml.v2.internal.utils.StreamUtils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Optional;

public class DwShapeTypeLoader implements TypeLoader {

  public static MetadataFormat FORMAT = new MetadataFormat("Weave", "weave", "application/weave");

  private final File file;
  private final MetadataFormat metadataFormat;
  private final String content;

  public DwShapeTypeLoader(File file, MetadataFormat metadataFormat) {
    this.file = file;
    this.metadataFormat = metadataFormat;
    this.content = null;
  }

  public DwShapeTypeLoader(String content, MetadataFormat metadataFormat) {
    this.file = null;
    this.content = content;
    this.metadataFormat = metadataFormat;
  }

  @Override
  public Optional<MetadataType> load(String typeIdentifier) {
    return load(typeIdentifier, null);
  }

  private InputStream loadInputStream() throws FileNotFoundException {
    if (file != null) {
      return new FileInputStream(file);
    } else if (content != null) {
      return new ByteArrayInputStream(content.getBytes());
    } else {
      throw new RuntimeException(
                                 "Invalid file content specified.");
    }
  }

  @Override
  public Optional<MetadataType> load(String typeIdentifier, String typeAlias) {
    try (InputStream inputStream = loadInputStream()) {
      final String string = StreamUtils.toString(inputStream);
      WeaveTypeLoader weaveTypeLoader = new WeaveTypeLoader(string, metadataFormat);
      return weaveTypeLoader.load(typeIdentifier);
    } catch (Exception e) {
      throw Throwables.propagate(e);
    }
  }
}
