/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.dw;

import com.google.common.base.Throwables;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Optional;
import org.mule.metadata.MetadataFormats;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.el.ExpressionLanguageMetadataTypeResolver;

public class DwExampleTypeLoader
implements TypeLoader {
    private final File file;
    private final MetadataFormat metadataFormat;
    private final String content;
    private ExpressionLanguageMetadataTypeResolver expressionLanguageMetadataTypeResolver = ExpressionLanguageMetadataTypeResolver.getInstance((ClassLoader)DwExampleTypeLoader.class.getClassLoader());

    public DwExampleTypeLoader(File file, MetadataFormat metadataFormat) {
        this.file = file;
        this.metadataFormat = metadataFormat;
        this.content = null;
    }

    public DwExampleTypeLoader(String content, MetadataFormat metadataFormat) {
        this.metadataFormat = metadataFormat;
        this.file = null;
        this.content = content;
    }

    public Optional<MetadataType> load(String typeIdentifier) {
        return this.load(typeIdentifier, null);
    }

    private InputStream loadInputStream() throws FileNotFoundException {
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        if (this.content != null) {
            return new ByteArrayInputStream(this.content.getBytes());
        }
        throw new RuntimeException("Invalid file content specified.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<MetadataType> load(String typeIdentifier, String typeAlias) {
        try (InputStream inputStream = this.loadInputStream();){
            HashMap properties = new HashMap();
            MetadataType metadataFromSample = this.expressionLanguageMetadataTypeResolver.getMetadataFromSample(inputStream, properties, MetadataFormats.getMimeType(this.metadataFormat));
            Optional<MetadataType> optional = Optional.of(metadataFromSample);
            return optional;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

