/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.raml.fragments;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.text.IsEqualIgnoringWhiteSpace;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.internal.utils.MetadataTypeWriter;
import org.mule.metadata.raml.RamlTypeLoader;
import org.xml.sax.SAXException;

@RunWith(value=Parameterized.class)
public class DataTypeRamlFragmentTypeLoaderTest {
    private File ramlFile;
    private String name;
    private File expectedMetadataTypeFile;

    public DataTypeRamlFragmentTypeLoaderTest(File ramlFile, File expectedMetadataTypeFile, String name) {
        this.ramlFile = ramlFile;
        this.name = name;
        this.expectedMetadataTypeFile = expectedMetadataTypeFile;
    }

    @Parameterized.Parameters(name="{2}")
    public static Collection<Object[]> data() throws URISyntaxException {
        URI baseFolder = DataTypeRamlFragmentTypeLoaderTest.class.getResource("").toURI();
        File testFolder = new File(baseFolder);
        File[] scenarios = testFolder.listFiles();
        if (scenarios != null) {
            Stream<Object[]> testInput = Arrays.stream(scenarios).filter(File::isDirectory).filter(file -> {
                String test = System.getProperty("test");
                return test == null || file.getName().startsWith(test);
            }).map(scenario -> {
                File ramlFile = new File((File)scenario, "in.raml");
                File expectedMetadataTypeFile = new File((File)scenario, "out.type");
                return new Object[]{ramlFile, expectedMetadataTypeFile, scenario.getName()};
            });
            return testInput.collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Test
    public void createModel() throws IOException, SAXException {
        Optional metadataTypeOptional = new RamlTypeLoader(this.ramlFile, new MetadataFormat("RAML", "raml", new String[]{"application/raml"})).load(null);
        Assert.assertThat((Object)metadataTypeOptional.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        String actual = new MetadataTypeWriter().toString((MetadataType)metadataTypeOptional.get());
        Assert.assertThat((Object)actual, (Matcher)IsEqualIgnoringWhiteSpace.equalToIgnoringWhiteSpace((String)IOUtils.toString((InputStream)new FileInputStream(this.expectedMetadataTypeFile))));
    }
}

