/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.map;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.text.IsEqualIgnoringWhiteSpace;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.internal.utils.MetadataTypeWriter;
import org.mule.metadata.map.MapTypeLoader;
import org.xml.sax.SAXException;

@RunWith(value=Parameterized.class)
public class MapTypeLoaderTest {
    public static final String ACCESS_EXTERNAL_DTD = "javax.xml.accessExternalDTD";
    private File ramlFile;
    private String name;
    private File expectedMetadataTypeFile;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    public MapTypeLoaderTest(File ramlFile, File expectedMetadataTypeFile, String name) {
        this.ramlFile = ramlFile;
        this.name = name;
        this.expectedMetadataTypeFile = expectedMetadataTypeFile;
    }

    @Parameterized.Parameters(name="{2}")
    public static Collection<Object[]> data() throws URISyntaxException {
        URI baseFolder = MapTypeLoaderTest.class.getResource("").toURI();
        File testFolder = new File(baseFolder);
        File[] scenarios = testFolder.listFiles();
        if (scenarios != null) {
            Stream<Object[]> testInput = Arrays.stream(scenarios).filter(File::isDirectory).filter(file -> {
                String test = System.getProperty("test");
                return test == null || file.getName().startsWith(test);
            }).map(scenario -> {
                File ramlFile = new File((File)scenario, "in.raml");
                File expectedMetadataTypeFile = new File((File)scenario, "out.type");
                return new Object[]{ramlFile, expectedMetadataTypeFile, scenario.getName()};
            });
            return testInput.collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Test
    public void createModel() throws IOException, SAXException {
        Optional metadataTypeOptional = new MapTypeLoader(this.ramlFile).load(null);
        Assert.assertThat((Object)metadataTypeOptional.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        String actual = new MetadataTypeWriter().toString((MetadataType)metadataTypeOptional.get());
        Assert.assertThat((Object)actual, (Matcher)IsEqualIgnoringWhiteSpace.equalToIgnoringWhiteSpace((String)IOUtils.toString((InputStream)new FileInputStream(this.expectedMetadataTypeFile))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void disablesAccessToExternalDtds() {
        String javaSchema = "#%RAML 1.0\ntitle: api1\nversion: \"1.0\"\nschemas:\n  schema1: |\n   <?xml version=\"1.0\" ?>\n   <!DOCTYPE r [\n   <!ELEMENT r ANY >\n   <!ENTITY sp SYSTEM \"file:///etc/hostname\">\n   ]>\n   <r>&sp;</r>\n/test:\n  displayName: res1\n  get:\n  post:\n";
        MapTypeLoader loader = new MapTypeLoader(javaSchema);
        String originalPropertyValue = System.getProperty(ACCESS_EXTERNAL_DTD);
        try {
            System.setProperty(ACCESS_EXTERNAL_DTD, "");
            this.expectedException.expect(IllegalArgumentException.class);
            this.expectedException.expectMessage(CoreMatchers.containsString((String)"access is not allowed due to restriction set by the accessExternalDTD property"));
            loader.load(null);
        }
        finally {
            if (originalPropertyValue == null) {
                System.clearProperty(ACCESS_EXTERNAL_DTD);
            } else {
                System.setProperty(ACCESS_EXTERNAL_DTD, originalPropertyValue);
            }
        }
    }

    @Test
    @Ignore
    public void disablesRamlAnchorExpansion() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String javaSchema = "#%RAML 1.0 DataType\na: &a [\"lol\",\"lol\",\"lol\",\"lol\",\"lol\",\"lol\",\"lol\",\"lol\",\"lol\"]\nb: &b [*a,*a,*a,*a,*a,*a,*a,*a,*a]\nc: &c [*b,*b,*b,*b,*b,*b,*b,*b,*b]\nd: &d [*c,*c,*c,*c,*c,*c,*c,*c,*c]\ne: &e [*d,*d,*d,*d,*d,*d,*d,*d,*d]\nf: &f [*e,*e,*e,*e,*e,*e,*e,*e,*e]\ng: &g [*f,*f,*f,*f,*f,*f,*f,*f,*f]\nh: &h [*g,*g,*g,*g,*g,*g,*g,*g,*g]\ni: &i [*h,*h,*h,*h,*h,*h,*h,*h,*h]\ntype: object\nproperties:\n    field1:\n        type: string\n    field2:\n        properties:\n            field21:\n                type: string\n            field22:\n                type: string";
        MapTypeLoader loader = new MapTypeLoader(javaSchema);
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(CoreMatchers.containsString((String)"reference count exceeded"));
        loader.load(null);
    }
}

