/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.text.IsEqualIgnoringWhiteSpace;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.metadata.ExpressionLanguageMetadataServiceUtils;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.internal.utils.MetadataTypeWriter;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.xml.sax.SAXException;

@RunWith(value=Parameterized.class)
public abstract class BaseParameterizedTypeLoaderTest {
    private File file;
    private String name;
    private File expectedMetadataTypeFile;

    public BaseParameterizedTypeLoaderTest(File file, File expectedMetadataTypeFile, String name) {
        this.file = file;
        this.name = name;
        this.expectedMetadataTypeFile = expectedMetadataTypeFile;
    }

    protected abstract TypeLoader createTypeLoader(File var1, ExpressionLanguageMetadataService var2);

    protected static Collection<Object[]> generateData(Class clazz, String extension) throws URISyntaxException {
        URI baseFolder = clazz.getResource("").toURI();
        File testFolder = new File(baseFolder);
        File[] scenarios = testFolder.listFiles();
        if (scenarios != null) {
            Stream<Object[]> testInput = Arrays.stream(scenarios).filter(File::isDirectory).filter(file -> {
                String test = System.getProperty("test");
                return test == null || file.getName().startsWith(test);
            }).map(scenario -> {
                File file = new File((File)scenario, "in." + extension);
                File expectedMetadataTypeFile = new File((File)scenario, "out.type");
                return new Object[]{file, expectedMetadataTypeFile, scenario.getName()};
            });
            return testInput.collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Test
    public void createModel() throws IOException, SAXException {
        Optional metadataTypeOptional = this.createTypeLoader(this.file, ExpressionLanguageMetadataServiceUtils.createExpressionLanguageMetadataService()).load(null);
        Assert.assertThat((Object)metadataTypeOptional.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        String actual = new MetadataTypeWriter().toString((MetadataType)metadataTypeOptional.get());
        Assert.assertThat((Object)actual, (Matcher)IsEqualIgnoringWhiteSpace.equalToIgnoringWhiteSpace((String)IOUtils.toString((InputStream)new FileInputStream(this.expectedMetadataTypeFile))));
    }
}

