/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.raml.handler;

import java.util.List;
import java.util.Optional;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.StringTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.WithAnnotation;
import org.mule.metadata.raml.handler.BaseTypeDeclarationHandler;
import org.mule.metadata.raml.handler.ParsingContext;
import org.mule.metadata.raml.handler.TypeDeclarationHandlerManager;
import org.raml.v2.api.model.v10.datamodel.StringTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class StringTypeDeclarationHandler
extends BaseTypeDeclarationHandler {
    @Override
    public boolean handles(TypeDeclaration typeDeclaration) {
        return typeDeclaration instanceof StringTypeDeclaration;
    }

    @Override
    public TypeBuilder<?> handle(TypeDeclaration typeDeclaration, BaseTypeBuilder root, TypeDeclarationHandlerManager typeDeclarationHandlerManager, ParsingContext parsingContext) {
        StringTypeDeclaration stringTypeDeclaration = (StringTypeDeclaration)typeDeclaration;
        StringTypeBuilder stringTypeBuilder = root.stringType();
        List enumValues = stringTypeDeclaration.enumValues();
        if (enumValues != null && enumValues.size() > 0) {
            stringTypeBuilder.enumOf(enumValues.toArray(new String[enumValues.size()]));
        }
        Optional<Integer> minLength = Optional.ofNullable(stringTypeDeclaration.minLength());
        Optional<Integer> maxLength = Optional.ofNullable(stringTypeDeclaration.maxLength());
        if (minLength.isPresent() && maxLength.isPresent()) {
            stringTypeBuilder.boundary((Number)minLength.get(), (Number)maxLength.get());
        } else if (maxLength.isPresent()) {
            stringTypeBuilder.length(maxLength.get());
        }
        Optional<String> pattern = Optional.ofNullable(stringTypeDeclaration.pattern());
        if (pattern.isPresent()) {
            stringTypeBuilder.pattern(pattern.get());
        }
        this.handleAnnotations((WithAnnotation)stringTypeBuilder, stringTypeDeclaration.annotations());
        Optional<String> defaultValueOptional = Optional.ofNullable(stringTypeDeclaration.defaultValue());
        if (defaultValueOptional.isPresent()) {
            stringTypeBuilder.defaultValue(defaultValueOptional.get());
        }
        return stringTypeBuilder;
    }
}

