/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.dw;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Optional;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.raml.v2.internal.utils.StreamUtils;

public class DwShapeTypeLoader
implements TypeLoader {
    public static MetadataFormat FORMAT = new MetadataFormat("Weave", "weave", new String[]{"application/weave"});
    private final File file;
    private final MetadataFormat metadataFormat;
    private final String content;
    private final ExpressionLanguageMetadataService expressionLanguageMetadataService;

    public DwShapeTypeLoader(File file, MetadataFormat metadataFormat, ExpressionLanguageMetadataService expressionLanguageMetadataService) {
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkNotNull((Object)metadataFormat);
        Preconditions.checkNotNull((Object)expressionLanguageMetadataService);
        this.file = file;
        this.metadataFormat = metadataFormat;
        this.expressionLanguageMetadataService = expressionLanguageMetadataService;
        this.content = null;
    }

    public DwShapeTypeLoader(String content, MetadataFormat metadataFormat, ExpressionLanguageMetadataService expressionLanguageMetadataService) {
        Preconditions.checkNotNull((Object)content);
        Preconditions.checkNotNull((Object)metadataFormat);
        Preconditions.checkNotNull((Object)expressionLanguageMetadataService);
        this.expressionLanguageMetadataService = expressionLanguageMetadataService;
        this.file = null;
        this.content = content;
        this.metadataFormat = metadataFormat;
    }

    public Optional<MetadataType> load(String typeIdentifier) {
        return this.load(typeIdentifier, null);
    }

    private InputStream loadInputStream() throws FileNotFoundException {
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        if (this.content != null) {
            return new ByteArrayInputStream(this.content.getBytes());
        }
        throw new RuntimeException("Invalid file content specified.");
    }

    public Optional<MetadataType> load(String typeIdentifier, String typeAlias) {
        Optional optional;
        block8: {
            InputStream inputStream = this.loadInputStream();
            try {
                String string = StreamUtils.toString((InputStream)inputStream);
                TypeLoader typeLoader = this.expressionLanguageMetadataService.createTypeLoader(string, this.metadataFormat);
                optional = typeLoader.load(typeIdentifier);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
            inputStream.close();
        }
        return optional;
    }
}

