package org.mule.metadata;

import com.google.common.base.Preconditions;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.dw.DwShapeTypeLoader;
import org.mule.metadata.excel.ExcelExampleTypeLoader;
import org.mule.metadata.flatfile.FlatfileTypeLoader;

import java.util.Arrays;
import java.util.List;

public class MetadataFormats {

  public static MetadataFormat CSV = MetadataFormat.CSV;
  public static MetadataFormat JAVA = MetadataFormat.JAVA;
  public static MetadataFormat JSON = MetadataFormat.JSON;
  public static MetadataFormat XML = MetadataFormat.XML;
  public static MetadataFormat COPYBOOK = FlatfileTypeLoader.COPYBOOK;
  public static MetadataFormat FIXED_WIDTH = FlatfileTypeLoader.FIXED_WIDTH;
  public static MetadataFormat FLAT_FILE = FlatfileTypeLoader.FLAT_FILE;
  public static MetadataFormat EXCEL = ExcelExampleTypeLoader.FORMAT;
  public static MetadataFormat DW = DwShapeTypeLoader.FORMAT;

  private static List<MetadataFormat> metadataFormats =
      Arrays.asList(CSV, JAVA, JSON, XML, COPYBOOK, FIXED_WIDTH, FLAT_FILE, EXCEL, DW);

  public static MetadataFormat fromId(String metadataFormatId) {
    return metadataFormats.stream().filter(metadataFormat -> metadataFormat.getId().equals(metadataFormatId)).findFirst()
        .orElseThrow(() -> new IllegalArgumentException(String.format("Unknown metadata format %s.", metadataFormatId)));
  }

  public static String getMimeType(MetadataFormat metadataFormat) {
    Preconditions.checkNotNull(metadataFormat);
    return metadataFormat.getValidMimeTypes().stream().findFirst()
        .orElseThrow(() -> new IllegalArgumentException("Unknown mime type for " + metadataFormat.getId()));
  }
}
