package org.mule.metadata.dw;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.raml.v2.internal.utils.StreamUtils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Optional;

public class DwShapeTypeLoader implements TypeLoader {

  public static MetadataFormat FORMAT = new MetadataFormat("Weave", "weave", "application/weave");

  private final File file;
  private final MetadataFormat metadataFormat;
  private final String content;
  private final ExpressionLanguageMetadataService expressionLanguageMetadataService;

  public DwShapeTypeLoader(File file, MetadataFormat metadataFormat,
                           ExpressionLanguageMetadataService expressionLanguageMetadataService) {
    Preconditions.checkNotNull(file);
    Preconditions.checkNotNull(metadataFormat);
    Preconditions.checkNotNull(expressionLanguageMetadataService);
    this.file = file;
    this.metadataFormat = metadataFormat;
    this.expressionLanguageMetadataService = expressionLanguageMetadataService;
    this.content = null;
  }

  public DwShapeTypeLoader(String content, MetadataFormat metadataFormat,
                           ExpressionLanguageMetadataService expressionLanguageMetadataService) {
    Preconditions.checkNotNull(content);
    Preconditions.checkNotNull(metadataFormat);
    Preconditions.checkNotNull(expressionLanguageMetadataService);
    this.expressionLanguageMetadataService = expressionLanguageMetadataService;
    this.file = null;
    this.content = content;
    this.metadataFormat = metadataFormat;
  }

  @Override
  public Optional<MetadataType> load(String typeIdentifier) {
    return load(typeIdentifier, null);
  }

  private InputStream loadInputStream() throws FileNotFoundException {
    if (file != null) {
      return new FileInputStream(file);
    } else if (content != null) {
      return new ByteArrayInputStream(content.getBytes());
    } else {
      throw new RuntimeException(
                                 "Invalid file content specified.");
    }
  }

  @Override
  public Optional<MetadataType> load(String typeIdentifier, String typeAlias) {
    try (InputStream inputStream = loadInputStream()) {
      final String string = StreamUtils.toString(inputStream);
      final TypeLoader typeLoader = expressionLanguageMetadataService.createTypeLoader(string, metadataFormat);
      return typeLoader.load(typeIdentifier);
    } catch (Exception e) {
      throw Throwables.propagate(e);
    }
  }
}
