package org.mule.metadata.raml;

import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.raml.v2.api.RamlModelResult;
import org.raml.v2.api.model.v10.RamlFragment;

import java.io.File;
import java.util.Optional;

public class RamlTypeLoader implements TypeLoader {

  private final File ramlFile;
  private MetadataFormat metadataFormat;

  public RamlTypeLoader(File ramlFile, MetadataFormat metadataFormat) {
    this.ramlFile = ramlFile;

    this.metadataFormat = metadataFormat;
  }

  @Override
  public Optional<MetadataType> load(String typeIdentifier) {
    return load(typeIdentifier, null);
  }

  @Override
  public Optional<MetadataType> load(String typeIdentifier, String typeAlias) {
    try {
      Optional<MetadataType> result;

      final RamlModelResult ramlModelResult = RamlModelBuilderFactory.INSTANCE.createRamlModelBuilder().buildApi(ramlFile);

      if (ramlModelResult.hasErrors()) {
        throw new IllegalArgumentException(ramlModelResult.getValidationResults().toString());
      }

      if (ramlModelResult.getFragment() == RamlFragment.DataType) {
        final DataTypeRamlFragmentTypeLoader dataTypeRamlFragmentTypeLoader =
            new DataTypeRamlFragmentTypeLoader(ramlFile, metadataFormat);
        result = dataTypeRamlFragmentTypeLoader.load(typeIdentifier, typeAlias);
      } else if (ramlModelResult.getLibrary() != null) {
        final RamlTypeLibTypeLoader ramlTypeLibTypeLoader = new RamlTypeLibTypeLoader(ramlFile, metadataFormat);
        result = ramlTypeLibTypeLoader.load(typeIdentifier, typeAlias);
      } else {
        throw new IllegalArgumentException(String.format("Unsupported raml file '%s'.", ramlFile));
      }

      return result;
    } catch (RuntimeException e) {
      throw e;
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }
}
