package org.mule.metadata.raml.handler;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.raml.v2.api.model.v10.datamodel.BooleanTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class BooleanTypeDeclarationHandler implements TypeDeclarationHandler {

  @Override
  public boolean handles(TypeDeclaration typeDeclaration) {
    return typeDeclaration instanceof BooleanTypeDeclaration;
  }

  @Override
  public TypeBuilder<?> handle(TypeDeclaration typeDeclaration, BaseTypeBuilder root,
                               TypeDeclarationHandlerManager typeDeclarationHandlerManager,
                               ParsingContext parsingContext) {
    return root.booleanType();
  }
}
