package org.mule.metadata.raml.handler;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.NumberTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.raml.v2.api.model.v10.datamodel.IntegerTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class IntegerTypeDeclarationHandler extends NumberTypeDeclarationHandler {

  @Override
  public boolean handles(TypeDeclaration typeDeclaration) {
    return typeDeclaration instanceof IntegerTypeDeclaration;
  }

  @Override
  public TypeBuilder<?> handle(TypeDeclaration typeDeclaration, BaseTypeBuilder root,
                               TypeDeclarationHandlerManager typeDeclarationHandlerManager,
                               ParsingContext parsingContext) {
    NumberTypeBuilder numberTypeBuilder =
        (NumberTypeBuilder) super.handle(typeDeclaration, root, typeDeclarationHandlerManager, parsingContext);
    numberTypeBuilder.integer();
    return numberTypeBuilder;
  }
}
