package org.mule.metadata.dw;

import com.google.common.base.Preconditions;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

import java.io.File;
import java.util.Optional;

public abstract class DwBasedTypeLoader implements TypeLoader {

  private final TypeLoader delegate;
  private final ExpressionLanguageMetadataService expressionLanguageMetadataService;

  public DwBasedTypeLoader(File file,
                           ExpressionLanguageMetadataService expressionLanguageMetadataService) {
    this.expressionLanguageMetadataService = expressionLanguageMetadataService;
    delegate = createTypeLoader(file, getMetadataFormat());
  }

  public DwBasedTypeLoader(String content,
                           ExpressionLanguageMetadataService expressionLanguageMetadataService) {
    this.expressionLanguageMetadataService = expressionLanguageMetadataService;
    delegate = createTypeLoader(content, getMetadataFormat());
  }

  protected abstract TypeLoader createTypeLoader(File file, MetadataFormat metadataFormat);

  protected abstract TypeLoader createTypeLoader(String content, MetadataFormat metadataFormat);

  public static String getMimeType(MetadataFormat metadataFormat) {
    Preconditions.checkNotNull(metadataFormat);
    return metadataFormat.getValidMimeTypes().stream().findFirst()
        .orElseThrow(() -> new IllegalArgumentException("Unknown mime type for " + metadataFormat.getId()));
  }

  @Override
  public Optional<MetadataType> load(String typeIdentifier) {
    return load(typeIdentifier, null);
  }

  @Override
  public Optional<MetadataType> load(String typeIdentifier, String typeAlias) {
    return delegate.load(typeIdentifier, typeAlias);
  }

  protected abstract MetadataFormat getMetadataFormat();

  protected ExpressionLanguageMetadataService getExpressionLanguageMetadataService() {
    return expressionLanguageMetadataService;
  }
}
