package org.mule.metadata.dw;

import org.mule.metadata.api.TypeWriter;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

import java.util.HashMap;
import java.util.Map;

public class DwTypeWriter implements TypeWriter {

  private static final String DEFAULT_TYPE_NAME = "aType";

  private final ExpressionLanguageMetadataService expressionLanguageMetadataService;

  public DwTypeWriter(ExpressionLanguageMetadataService expressionLanguageMetadataService) {
    this.expressionLanguageMetadataService = expressionLanguageMetadataService;
  }

  private ExpressionLanguageMetadataService.MetadataTypeSerializer createWriter() {
    return expressionLanguageMetadataService.getTypeSerializer();
  }

  @Override
  public String toString(MetadataType metadataType) {
    Map<String, MetadataType> catalog = new HashMap<>();
    catalog.put(DEFAULT_TYPE_NAME, metadataType);
    return createWriter().serialize(catalog);
  }

  public String write(MetadataType metadataType, String name) {
    Map<String, MetadataType> catalog = new HashMap<>();
    catalog.put(name, metadataType);
    return createWriter().serialize(catalog);
  }

  public String write(Map<String, MetadataType> catalog) {
    return createWriter().serialize(catalog);
  }
}
