package org.mule.metadata.raml;

import org.raml.v2.api.RamlModelBuilder;

class RamlModelBuilderFactory {

  private final String DISALLOW_EXTERNAL_REFERENCES = "org.mule.metadata.raml.disallowExternalReferences";

  private boolean isDisallowExternalReferences() {
    return Boolean.getBoolean(DISALLOW_EXTERNAL_REFERENCES);
  }

  RamlModelBuilder createRamlModelBuilder() {
    return isDisallowExternalReferences() ? new RamlModelBuilder(new DisabledResourceLoader()) : new RamlModelBuilder();
  }

  static RamlModelBuilderFactory INSTANCE = new RamlModelBuilderFactory();
}
